/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.questionnaire.service.api.FormActions;
import io.dialob.session.engine.AbstractFormActionsUpdatesItemsVisitor;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.SessionObject;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

public class FormActionsUpdatesItemsVisitor
extends AbstractFormActionsUpdatesItemsVisitor {
    private final Function<ItemState, ActionItem> toActionItemFunction;

    public FormActionsUpdatesItemsVisitor(@NonNull FormActions formActions, @NonNull Predicate<SessionObject> isVisiblePredicate, @NonNull Function<ItemState, ActionItem> toActionItemFunction) {
        super(formActions, isVisiblePredicate);
        this.toActionItemFunction = toActionItemFunction;
    }

    @Override
    protected void updated(@NonNull ErrorState updated) {
        this.formActions.addError(Utils.toError(updated));
    }

    @Override
    protected void updated(@NonNull ValueSetState updated) {
        this.formActions.newValueSet(Utils.toValueSet(updated));
    }

    @Override
    protected void activated(@NonNull ErrorState updated) {
        this.formActions.addError(Utils.toError(updated));
    }

    @Override
    protected void inactivated(@NonNull ErrorState updated) {
        this.formActions.removeError((Error)ImmutableError.builder().id(IdUtils.toString(updated.getItemId())).code(updated.getCode()).build());
    }

    @Override
    protected void disabled(@NonNull ItemState updated) {
        this.updated(updated);
    }

    @Override
    protected void enabled(@NonNull ItemState updated) {
        this.updated(updated);
    }

    @Override
    protected void activated(@NonNull ItemState updated) {
        this.formActions.newQuestion(this.toActionItemFunction.apply(updated));
    }

    @Override
    protected void inactivated(@NonNull ItemState updated) {
        this.formActions.removeQuestion(IdUtils.toString(updated.getId()));
    }

    @Override
    protected void updated(@NonNull ItemState updated) {
        this.formActions.updateQuestion(this.toActionItemFunction.apply(updated));
    }

    @Override
    protected void languageChanged(@NonNull String language) {
        this.formActions.locale(Locale.of(language));
    }

    @Override
    public void visitCompleted() {
        this.formActions.complete();
    }
}

