/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.sp;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.proto.ActionsFactory;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.model.IdUtils;
import java.util.Collections;

public class AsyncFunctionInvoker {
    private final FunctionRegistry registry;
    private final QuestionnaireSessionService service;

    public AsyncFunctionInvoker(@NonNull FunctionRegistry registry, @NonNull QuestionnaireSessionService service) {
        this.registry = registry;
        this.service = service;
    }

    public EvalContext.UpdatedItemsVisitor.AsyncFunctionCallVisitor createVisitor(String sessionId) {
        return asyncFunctionCall -> this.registry.invokeFunctionAsync((FunctionRegistry.FunctionCallback)new AsyncFunctionCallback(this.service, sessionId, IdUtils.toString(asyncFunctionCall.getTargetId().get())), asyncFunctionCall.getFunctionName(), asyncFunctionCall.getArgs());
    }

    private static class AsyncFunctionCallback
    implements FunctionRegistry.FunctionCallback {
        private final QuestionnaireSessionService service;
        private final String sessionId;
        private final String targetId;

        public AsyncFunctionCallback(QuestionnaireSessionService service, String sessionId, String targetId) {
            this.service = service;
            this.sessionId = sessionId;
            this.targetId = targetId;
        }

        public void succeeded(Object result) {
            QuestionnaireSession questionnaireSession = this.service.findOne(this.sessionId, true);
            questionnaireSession.dispatchActions(Collections.singletonList(ActionsFactory.setValue((String)this.targetId, (Object)result)));
        }

        public void failed(@NonNull String error) {
            QuestionnaireSession questionnaireSession = this.service.findOne(this.sessionId, true);
            questionnaireSession.dispatchActions(Collections.singletonList(ActionsFactory.setFailed((String)this.targetId, (Object)error)));
        }
    }
}

