/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.Scope;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Scope", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableScope
implements Scope {
    private final ItemId scopeId;
    private final ImmutableSet<ItemId> scopeItems;

    private ImmutableScope(ItemId scopeId, Iterable<? extends ItemId> scopeItems) {
        this.scopeId = Objects.requireNonNull(scopeId, "scopeId");
        this.scopeItems = ImmutableSet.copyOf(scopeItems);
    }

    private ImmutableScope(ImmutableScope original, ItemId scopeId, ImmutableSet<ItemId> scopeItems) {
        this.scopeId = scopeId;
        this.scopeItems = scopeItems;
    }

    @Override
    public ItemId getScopeId() {
        return this.scopeId;
    }

    public ImmutableSet<ItemId> getScopeItems() {
        return this.scopeItems;
    }

    public final ImmutableScope withScopeId(ItemId value) {
        if (this.scopeId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "scopeId");
        return new ImmutableScope(this, newValue, this.scopeItems);
    }

    public final ImmutableScope withScopeItems(ItemId ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableScope(this, this.scopeId, (ImmutableSet<ItemId>)newValue);
    }

    public final ImmutableScope withScopeItems(Iterable<? extends ItemId> elements) {
        if (this.scopeItems == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableScope(this, this.scopeId, (ImmutableSet<ItemId>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScope && this.equalsByValue((ImmutableScope)another);
    }

    private boolean equalsByValue(ImmutableScope another) {
        return this.scopeId.equals(another.scopeId) && this.scopeItems.equals(another.scopeItems);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scopeId.hashCode();
        h += (h << 5) + this.scopeItems.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Scope").omitNullValues().add("scopeId", (Object)this.scopeId).add("scopeItems", this.scopeItems).toString();
    }

    public static ImmutableScope of(ItemId scopeId, Set<ItemId> scopeItems) {
        return ImmutableScope.of(scopeId, scopeItems);
    }

    public static ImmutableScope of(ItemId scopeId, Iterable<? extends ItemId> scopeItems) {
        return new ImmutableScope(scopeId, scopeItems);
    }

    public static ImmutableScope copyOf(Scope instance) {
        if (instance instanceof ImmutableScope) {
            return (ImmutableScope)instance;
        }
        return ImmutableScope.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Scope", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCOPE_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private ItemId scopeId;
        private ImmutableSet.Builder<ItemId> scopeItems = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Scope instance) {
            Objects.requireNonNull(instance, "instance");
            this.scopeId(instance.getScopeId());
            this.addAllScopeItems(instance.getScopeItems());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scopeId(ItemId scopeId) {
            this.scopeId = Objects.requireNonNull(scopeId, "scopeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addScopeItems(ItemId element) {
            this.scopeItems.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addScopeItems(ItemId ... elements) {
            this.scopeItems.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scopeItems(Iterable<? extends ItemId> elements) {
            this.scopeItems = ImmutableSet.builder();
            return this.addAllScopeItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllScopeItems(Iterable<? extends ItemId> elements) {
            this.scopeItems.addAll(elements);
            return this;
        }

        public ImmutableScope build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScope(null, this.scopeId, (ImmutableSet<ItemId>)this.scopeItems.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scopeId");
            }
            return "Cannot build Scope, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

