/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.security.tenant.ResysSecurityConstants;
import io.dialob.session.engine.DebugUtil;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.ErrorUpdateCommand;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.command.SessionUpdateCommand;
import io.dialob.session.engine.session.command.SetAnswer;
import io.dialob.session.engine.session.command.UpdateValueSetCommand;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.model.DialobSessionVisitor;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableErrorId;
import io.dialob.session.engine.session.model.ImmutableItemRef;
import io.dialob.session.engine.session.model.ImmutableScope;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemIndex;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ItemStates;
import io.dialob.session.engine.session.model.SessionObject;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobSession
implements ItemStates,
Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobSession.class);
    private static final long serialVersionUID = 1180110179877247767L;
    public static final ImmutableItemRef QUESTIONNAIRE_REF = (ImmutableItemRef)IdUtils.toId("questionnaire");
    private final String tenantId;
    private final String id;
    private int asyncUpdateCount;
    private String revision;
    @NonNull
    private Date lastUpdate = new Date();
    private Date completed;
    private Date opened;
    private String language;
    private Map<ItemId, ItemState> itemStates = new HashMap<ItemId, ItemState>();
    private Map<ItemId, ItemState> itemPrototypes = new HashMap<ItemId, ItemState>();
    private Map<ValueSetId, ValueSetState> valueSetStates = new HashMap<ValueSetId, ValueSetState>();
    private Map<ErrorId, ErrorState> errorStates = new HashMap<ErrorId, ErrorState>();
    private Map<ErrorId, ErrorState> errorPrototypes = new HashMap<ErrorId, ErrorState>();

    public void writeTo(CodedOutputStream output) throws IOException {
        Utils.writeNullableString(output, this.tenantId);
        Utils.writeNullableString(output, this.id);
        output.writeStringNoTag(this.revision);
        output.writeStringNoTag(this.language);
        output.writeInt64NoTag(this.lastUpdate.getTime());
        Utils.writeNullableDate(output, this.completed);
        Utils.writeNullableDate(output, this.opened);
        output.writeInt32NoTag(this.asyncUpdateCount);
        output.writeInt32NoTag(this.itemStates.size());
        for (ItemState itemState : this.itemStates.values()) {
            itemState.writeTo(output);
        }
        output.writeInt32NoTag(this.itemPrototypes.size());
        for (ItemState itemState : this.itemPrototypes.values()) {
            itemState.writeTo(output);
        }
        output.writeInt32NoTag(this.valueSetStates.size());
        for (ValueSetState valueSetState : this.valueSetStates.values()) {
            valueSetState.writeTo(output);
        }
        output.writeInt32NoTag(this.errorStates.size());
        for (ErrorState errorState : this.errorStates.values()) {
            errorState.writeTo(output);
        }
        output.writeInt32NoTag(this.errorPrototypes.size());
        for (ErrorState state : this.errorPrototypes.values()) {
            state.writeTo(output);
        }
    }

    public static DialobSession readFrom(CodedInputStream input) throws IOException {
        SessionObject state;
        int i;
        String tenantId = Utils.readNullableString(input);
        String id = Utils.readNullableString(input);
        DialobSession session = new DialobSession(tenantId, id);
        session.revision = input.readString();
        session.language = input.readString();
        session.lastUpdate = new Date(input.readInt64());
        session.completed = Utils.readNullableDate(input);
        session.opened = Utils.readNullableDate(input);
        session.asyncUpdateCount = input.readInt32();
        int count = input.readInt32();
        for (i = 0; i < count; ++i) {
            state = ItemState.readFrom(input);
            session.itemStates.put(((ItemState)state).getId(), (ItemState)state);
        }
        count = input.readInt32();
        for (i = 0; i < count; ++i) {
            state = ItemState.readFrom(input);
            session.itemPrototypes.put(((ItemState)state).getId(), (ItemState)state);
        }
        count = input.readInt32();
        for (i = 0; i < count; ++i) {
            state = ValueSetState.readFrom(input);
            session.valueSetStates.put(((ValueSetState)state).getId(), (ValueSetState)state);
        }
        count = input.readInt32();
        for (i = 0; i < count; ++i) {
            state = ErrorState.readFrom(input);
            session.errorStates.put(((ErrorState)state).getId(), (ErrorState)state);
        }
        count = input.readInt32();
        for (i = 0; i < count; ++i) {
            state = ErrorState.readFrom(input);
            session.errorPrototypes.put(((ErrorState)state).getId(), (ErrorState)state);
        }
        return session;
    }

    private DialobSession(String tenantId, @Nullable String id) {
        this.tenantId = tenantId;
        this.id = id;
    }

    public DialobSession(String tenantId, String id, String revision, String language, List<ItemState> items, List<ItemState> prototypes, List<ValueSetState> valueSets, List<ErrorState> errors, List<ErrorState> errorPrototypes, Date completed, Date opened, Date lastAnswer) {
        this(tenantId, id);
        this.revision = revision;
        this.language = language;
        if (completed != null) {
            this.completed = new Date(completed.getTime());
        }
        if (opened != null) {
            this.opened = new Date(opened.getTime());
        }
        if (items != null) {
            items.forEach(item -> this.itemStates.put(item.getId(), (ItemState)item));
        }
        if (valueSets != null) {
            valueSets.forEach(item -> this.valueSetStates.put(item.getId(), (ValueSetState)item));
        }
        if (errors != null) {
            errors.forEach(item -> this.errorStates.put(ImmutableErrorId.of(item.getItemId(), item.getCode()), (ErrorState)item));
        }
        if (errorPrototypes != null) {
            errorPrototypes.forEach(item -> this.errorPrototypes.put(ImmutableErrorId.of(item.getItemId(), item.getCode()), (ErrorState)item));
        }
        if (prototypes != null) {
            prototypes.forEach(prototype -> this.itemPrototypes.put(prototype.getId(), (ItemState)prototype));
        }
        this.updated();
        if (lastAnswer != null) {
            this.lastUpdate = new Date(lastAnswer.getTime());
        }
    }

    private DialobSession(String id, DialobSession dialobSession) {
        this.id = id;
        this.tenantId = dialobSession.tenantId;
        this.revision = dialobSession.revision;
        this.lastUpdate = new Date(dialobSession.lastUpdate.getTime());
        this.opened = dialobSession.opened != null ? new Date(dialobSession.opened.getTime()) : null;
        this.completed = dialobSession.completed != null ? new Date(dialobSession.completed.getTime()) : null;
        this.language = dialobSession.language;
        this.itemStates = new HashMap<ItemId, ItemState>(dialobSession.itemStates);
        this.itemPrototypes = new HashMap<ItemId, ItemState>(dialobSession.itemPrototypes);
        this.valueSetStates = new HashMap<ValueSetId, ValueSetState>(dialobSession.valueSetStates);
        this.errorStates = new HashMap<ErrorId, ErrorState>(dialobSession.errorStates);
        this.errorPrototypes = new HashMap<ErrorId, ErrorState>(dialobSession.errorPrototypes);
    }

    public DialobSession withId(String id) {
        if (Objects.equals(this.id, id)) {
            return this;
        }
        return new DialobSession(id, this);
    }

    public String getTenantId() {
        if (this.tenantId == null) {
            return ResysSecurityConstants.DEFAULT_TENANT.id();
        }
        return this.tenantId;
    }

    @NonNull
    public ItemState getRootItem() {
        return this.getItemState(QUESTIONNAIRE_REF).orElseThrow(() -> new IllegalStateException("Could not find questionnaire from " + this.getId()));
    }

    public Optional<ItemState> getItemState(@NonNull ItemId id) {
        return Optional.ofNullable(this.itemStates.get(id));
    }

    public void accept(DialobSessionVisitor visitor) {
        visitor.start();
        visitor.visitItemStates().ifPresent(itemVisitor -> {
            this.itemStates.values().forEach(itemVisitor::visitItemState);
            itemVisitor.end();
        });
        visitor.visitValueSetStates().ifPresent(valueSetVisitor -> {
            this.valueSetStates.values().forEach(valueSetVisitor::visitValueSetState);
            valueSetVisitor.end();
        });
        visitor.visitErrorStates().ifPresent(errorVisitor -> {
            this.getErrorStates().values().forEach(errorVisitor::visitErrorState);
            errorVisitor.end();
        });
        visitor.end();
    }

    public void applyUpdate(@NonNull EvalContext evalContext, @NonNull Command<?> command) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("applyUpdate({})", (Object)DebugUtil.commandToString(command));
        }
        if (command instanceof ItemUpdateCommand) {
            ItemUpdateCommand itemUpdateCommand = (ItemUpdateCommand)command;
            Object itemId = itemUpdateCommand.getTargetId();
            EvalContext context = this.createScopedEvalContext(evalContext, (ItemId)itemId);
            this.applyItemUpdateCommand(context, itemUpdateCommand);
            this.updated();
        } else if (command instanceof ErrorUpdateCommand) {
            ErrorUpdateCommand errorUpdateCommand = (ErrorUpdateCommand)command;
            EvalContext context = this.createScopedEvalContext(evalContext, ((ErrorId)errorUpdateCommand.getTargetId()).getItemId());
            this.applyErrorUpdateCommand(context, errorUpdateCommand);
            this.updated();
        } else if (command instanceof UpdateValueSetCommand) {
            UpdateValueSetCommand valueSetCommand = (UpdateValueSetCommand)command;
            this.applyUpdateValueSetCommand(evalContext, valueSetCommand);
            this.updated();
        } else if (command instanceof SessionUpdateCommand) {
            SessionUpdateCommand updateCommand = (SessionUpdateCommand)command;
            this.applySessionUpdateCommand(evalContext, updateCommand);
            this.updated();
        } else {
            LOGGER.warn("Do not know how to apply command: {}", command);
        }
    }

    public EvalContext createScopedEvalContext(@NonNull EvalContext evalContext, ItemId itemId) {
        return itemId instanceof ItemIndex ? this.createScope(evalContext, itemId) : itemId.getParent().map(parentId -> {
            if (parentId instanceof ItemIndex) {
                return this.createScope(evalContext, (ItemId)parentId);
            }
            return evalContext;
        }).orElse(evalContext);
    }

    public EvalContext createScope(@NonNull EvalContext evalContext, ItemId itemId) {
        ArrayList<ItemId> scopeItems = new ArrayList<ItemId>(evalContext.getItemState(itemId).map(ItemState::getItems).orElseGet(Collections::emptyList));
        scopeItems.add(itemId);
        return evalContext.withScope(ImmutableScope.of(itemId, scopeItems));
    }

    private void applySessionUpdateCommand(EvalContext evalContext, SessionUpdateCommand command) {
        ItemStates newStates = command.update(evalContext, this);
        command.getTriggers().stream().flatMap(trigger -> trigger.apply(this, newStates)).forEach(event -> evalContext.getEventsConsumer().accept((Event)event));
        MapDifference errorDiffs = Maps.difference(newStates.getErrorStates(), this.errorStates);
        MapDifference itemStatesDiffs = Maps.difference(newStates.getItemStates(), this.itemStates);
        itemStatesDiffs.entriesOnlyOnRight().forEach((itemId, itemState) -> {
            evalContext.registerUpdate(null, (ItemState)itemState);
            this.itemStates.remove(itemState.getId());
        });
        errorDiffs.entriesOnlyOnRight().forEach((errorId, errorState) -> {
            evalContext.registerUpdate(null, (ErrorState)errorState);
            this.errorStates.remove(errorId);
        });
        itemStatesDiffs.entriesOnlyOnLeft().forEach((itemId, itemState) -> {
            evalContext.registerUpdate((ItemState)itemState, null);
            this.itemStates.put(itemState.getId(), (ItemState)itemState);
        });
        errorDiffs.entriesOnlyOnLeft().forEach((errorId, errorState) -> {
            evalContext.registerUpdate((ErrorState)errorState, null);
            this.errorStates.put(errorState.getId(), (ErrorState)errorState);
        });
        itemStatesDiffs.entriesDiffering().forEach((itemId, itemStateDiff) -> {
            evalContext.registerUpdate((ItemState)itemStateDiff.leftValue(), (ItemState)itemStateDiff.rightValue());
            this.itemStates.put(((ItemState)itemStateDiff.leftValue()).getId(), (ItemState)itemStateDiff.leftValue());
        });
        errorDiffs.entriesDiffering().forEach((errorId, errorState) -> {
            evalContext.registerUpdate((ErrorState)errorState.leftValue(), (ErrorState)errorState.rightValue());
            this.errorStates.put(((ErrorState)errorState.leftValue()).getId(), (ErrorState)errorState.leftValue());
        });
    }

    private void applyUpdateValueSetCommand(EvalContext evalContext, UpdateValueSetCommand updateCommand) {
        this.valueSetStates.computeIfPresent((ValueSetId)updateCommand.getTargetId(), (key, state) -> {
            ValueSetState updatedState = updateCommand.update(evalContext, (ValueSetState)state);
            updateCommand.getTriggers().stream().flatMap(trigger -> trigger.apply(state, updatedState)).forEach(event -> evalContext.getEventsConsumer().accept((Event)event));
            evalContext.registerUpdate(updatedState, (ValueSetState)state);
            return updatedState;
        });
    }

    private void applyErrorUpdateCommand(EvalContext evalContext, ErrorUpdateCommand updateCommand) {
        this.errorStates.computeIfPresent((ErrorId)updateCommand.getTargetId(), (key, state) -> {
            ErrorState updatedState = updateCommand.update(evalContext, state);
            updateCommand.getTriggers().stream().flatMap(trigger -> trigger.apply(state, updatedState)).forEach(event -> evalContext.getEventsConsumer().accept((Event)event));
            evalContext.registerUpdate(updatedState, (ErrorState)state);
            return updatedState;
        });
    }

    private void applyItemUpdateCommand(EvalContext evalContext, ItemUpdateCommand updateCommand) {
        this.itemStates.computeIfPresent((ItemId)updateCommand.getTargetId(), (key, state) -> {
            ItemState updatedState = updateCommand.update(evalContext, state);
            updateCommand.getTriggers().stream().flatMap(trigger -> trigger.apply(state, updatedState)).forEach(event -> evalContext.getEventsConsumer().accept((Event)event));
            if (state.isDisplayItem() && !(updateCommand instanceof SetAnswer)) {
                evalContext.registerUpdate(updatedState, (ItemState)state);
            }
            return updatedState;
        });
    }

    protected void updated() {
        this.lastUpdate = new Date();
        if (this.opened == null) {
            this.opened = this.lastUpdate;
        }
        this.revision = Integer.toString(ThreadLocalRandom.current().nextInt());
        LOGGER.trace("{} updated to rev {}", (Object)this.getId(), (Object)this.revision);
    }

    public ErrorState findErrorState(ErrorId id) {
        return this.errorStates.get(id);
    }

    public Optional<ErrorState> getErrorState(ItemId itemId, String code) {
        return Optional.ofNullable(this.errorStates.get(ImmutableErrorId.of(itemId, code)));
    }

    @NonNull
    public Instant getLastUpdate() {
        return this.lastUpdate.toInstant();
    }

    @Nullable
    public Instant getCompleted() {
        if (this.completed == null) {
            return null;
        }
        return this.completed.toInstant();
    }

    @Nullable
    public Instant getOpened() {
        if (this.opened == null) {
            return null;
        }
        return this.opened.toInstant();
    }

    @Nullable
    public Instant getLastAnswer() {
        if (this.lastUpdate == null) {
            return null;
        }
        return this.lastUpdate.toInstant();
    }

    public boolean isCompleted() {
        return this.completed != null;
    }

    public boolean complete() {
        if (this.completed == null) {
            this.completed = new Date();
        }
        return this.isCompleted();
    }

    @Override
    @NonNull
    public Map<ItemId, ItemState> getItemStates() {
        return Collections.unmodifiableMap(this.itemStates);
    }

    @Override
    @NonNull
    public Map<ValueSetId, ValueSetState> getValueSetStates() {
        return Collections.unmodifiableMap(this.valueSetStates);
    }

    @Override
    @NonNull
    public Map<ErrorId, ErrorState> getErrorStates() {
        return Collections.unmodifiableMap(this.errorStates);
    }

    @NonNull
    public Optional<ValueSetState> getValueSetState(ValueSetId id) {
        return Optional.of(this.valueSetStates.get(id));
    }

    public Optional<ItemState> findHoistingGroup(ItemId id) {
        return this.itemStates.values().stream().filter(itemState -> itemState.getItems().contains(id)).findFirst();
    }

    public Optional<ItemState> findPrototype(ItemId itemId) {
        if (itemId.isPartial()) {
            return Optional.ofNullable(this.itemPrototypes.get(itemId));
        }
        return this.itemPrototypes.values().stream().filter(itemState -> IdUtils.matches(itemState.getId(), itemId)).findFirst();
    }

    @NonNull
    private Stream<Map.Entry<ItemId, ItemState>> findMatchingItemsEntries(ItemId partialItemId) {
        return this.itemStates.entrySet().stream().filter(item -> IdUtils.matches(partialItemId, (ItemId)item.getKey()));
    }

    @NonNull
    private Stream<Map.Entry<ErrorId, ErrorState>> findMatchingErrorEntries(ErrorId partialErrorId) {
        return this.errorStates.entrySet().stream().filter(item -> IdUtils.matches(partialErrorId, (ItemId)item.getKey()));
    }

    @NonNull
    public Stream<ItemId> findMatchingItemIds(ItemId partialItemId) {
        UnaryOperator logger;
        UnaryOperator unaryOperator = logger = LOGGER.isDebugEnabled() ? itemEntry -> {
            LOGGER.debug("Matched {} -> {}", (Object)partialItemId, itemEntry.getKey());
            return itemEntry;
        } : UnaryOperator.identity();
        if (partialItemId instanceof ErrorId) {
            ErrorId errorId = (ErrorId)partialItemId;
            return this.findMatchingErrorEntries(errorId).map(logger).map(Map.Entry::getKey);
        }
        return this.findMatchingItemsEntries(partialItemId).map(logger).map(Map.Entry::getKey);
    }

    @NonNull
    public Stream<ErrorState> findErrorPrototypes(ItemId itemId) {
        if (itemId.isPartial()) {
            return this.errorPrototypes.values().stream().filter(errorPrototype -> errorPrototype.getItemId().equals(itemId));
        }
        return this.errorPrototypes.values().stream().filter(errorPrototype -> IdUtils.matches(errorPrototype.getItemId(), itemId));
    }

    public String generateUpdateId() {
        return Integer.toString(this.asyncUpdateCount++);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialobSession)) {
            return false;
        }
        DialobSession other = (DialobSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.asyncUpdateCount != other.asyncUpdateCount) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$revision = this.getRevision();
        String other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !this$revision.equals(other$revision)) {
            return false;
        }
        Instant this$lastUpdate = this.getLastUpdate();
        Instant other$lastUpdate = other.getLastUpdate();
        if (this$lastUpdate == null ? other$lastUpdate != null : !((Object)this$lastUpdate).equals(other$lastUpdate)) {
            return false;
        }
        Instant this$completed = this.getCompleted();
        Instant other$completed = other.getCompleted();
        if (this$completed == null ? other$completed != null : !((Object)this$completed).equals(other$completed)) {
            return false;
        }
        Instant this$opened = this.getOpened();
        Instant other$opened = other.getOpened();
        if (this$opened == null ? other$opened != null : !((Object)this$opened).equals(other$opened)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        Map<ItemId, ItemState> this$itemStates = this.getItemStates();
        Map<ItemId, ItemState> other$itemStates = other.getItemStates();
        if (this$itemStates == null ? other$itemStates != null : !((Object)this$itemStates).equals(other$itemStates)) {
            return false;
        }
        Map<ItemId, ItemState> this$itemPrototypes = this.itemPrototypes;
        Map<ItemId, ItemState> other$itemPrototypes = other.itemPrototypes;
        if (this$itemPrototypes == null ? other$itemPrototypes != null : !((Object)this$itemPrototypes).equals(other$itemPrototypes)) {
            return false;
        }
        Map<ValueSetId, ValueSetState> this$valueSetStates = this.getValueSetStates();
        Map<ValueSetId, ValueSetState> other$valueSetStates = other.getValueSetStates();
        if (this$valueSetStates == null ? other$valueSetStates != null : !((Object)this$valueSetStates).equals(other$valueSetStates)) {
            return false;
        }
        Map<ErrorId, ErrorState> this$errorStates = this.getErrorStates();
        Map<ErrorId, ErrorState> other$errorStates = other.getErrorStates();
        if (this$errorStates == null ? other$errorStates != null : !((Object)this$errorStates).equals(other$errorStates)) {
            return false;
        }
        Map<ErrorId, ErrorState> this$errorPrototypes = this.errorPrototypes;
        Map<ErrorId, ErrorState> other$errorPrototypes = other.errorPrototypes;
        return !(this$errorPrototypes == null ? other$errorPrototypes != null : !((Object)this$errorPrototypes).equals(other$errorPrototypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DialobSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.asyncUpdateCount;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : $revision.hashCode());
        Instant $lastUpdate = this.getLastUpdate();
        result = result * 59 + ($lastUpdate == null ? 43 : ((Object)$lastUpdate).hashCode());
        Instant $completed = this.getCompleted();
        result = result * 59 + ($completed == null ? 43 : ((Object)$completed).hashCode());
        Instant $opened = this.getOpened();
        result = result * 59 + ($opened == null ? 43 : ((Object)$opened).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        Map<ItemId, ItemState> $itemStates = this.getItemStates();
        result = result * 59 + ($itemStates == null ? 43 : ((Object)$itemStates).hashCode());
        Map<ItemId, ItemState> $itemPrototypes = this.itemPrototypes;
        result = result * 59 + ($itemPrototypes == null ? 43 : ((Object)$itemPrototypes).hashCode());
        Map<ValueSetId, ValueSetState> $valueSetStates = this.getValueSetStates();
        result = result * 59 + ($valueSetStates == null ? 43 : ((Object)$valueSetStates).hashCode());
        Map<ErrorId, ErrorState> $errorStates = this.getErrorStates();
        result = result * 59 + ($errorStates == null ? 43 : ((Object)$errorStates).hashCode());
        Map<ErrorId, ErrorState> $errorPrototypes = this.errorPrototypes;
        result = result * 59 + ($errorPrototypes == null ? 43 : ((Object)$errorPrototypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DialobSession(tenantId=" + this.getTenantId() + ", id=" + this.getId() + ", asyncUpdateCount=" + this.asyncUpdateCount + ", revision=" + this.getRevision() + ", lastUpdate=" + String.valueOf(this.getLastUpdate()) + ", completed=" + String.valueOf(this.getCompleted()) + ", opened=" + String.valueOf(this.getOpened()) + ", language=" + this.getLanguage() + ", itemStates=" + String.valueOf(this.getItemStates()) + ", itemPrototypes=" + String.valueOf(this.itemPrototypes) + ", valueSetStates=" + String.valueOf(this.getValueSetStates()) + ", errorStates=" + String.valueOf(this.getErrorStates()) + ", errorPrototypes=" + String.valueOf(this.errorPrototypes) + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getRevision() {
        return this.revision;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }
}

