/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface UpdateClassNames
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Value.Parameter(order=1)
    public Expression getExpression();

    @Override
    @NonNull
    default public Set<EventMatcher> getEventMatchers() {
        HashSet<EventMatcher> set = new HashSet<EventMatcher>(this.getExpression().getEvalRequiredConditions());
        if (this.getTargetId().isPartial()) {
            set.add(EventMatchers.whenItemAdded(this.getTargetId()));
        }
        return Set.copyOf(set);
    }

    @Override
    @NonNull
    default public ItemState update(@NonNull EvalContext context, @NonNull ItemState itemState) {
        return itemState.update().setClassNames(this.evalExpression(context)).get();
    }

    default public List<String> evalExpression(EvalContext context) {
        List stringValues = (List)this.getExpression().eval(context);
        if (stringValues == null) {
            return Collections.emptyList();
        }
        return stringValues.stream().map(stringValue -> (String)stringValue.eval(context)).toList();
    }
}

