/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.ErrorUpdateCommand;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.ValidationDisabledUpdateCommand;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValidationDisabledUpdateCommand", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableValidationDisabledUpdateCommand
implements ValidationDisabledUpdateCommand {
    private final ImmutableList<Trigger<ErrorState>> triggers;
    private final ErrorId targetId;
    private final Expression expression;

    private ImmutableValidationDisabledUpdateCommand(ErrorId targetId, Expression expression, Iterable<? extends Trigger<ErrorState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.expression = Objects.requireNonNull(expression, "expression");
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableValidationDisabledUpdateCommand(ImmutableValidationDisabledUpdateCommand original, ImmutableList<Trigger<ErrorState>> triggers, ErrorId targetId, Expression expression) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.expression = expression;
    }

    @Override
    public ImmutableList<Trigger<ErrorState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ErrorId getTargetId() {
        return this.targetId;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @SafeVarargs
    public final ImmutableValidationDisabledUpdateCommand withTriggers(Trigger<ErrorState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableValidationDisabledUpdateCommand(this, (ImmutableList<Trigger<ErrorState>>)newValue, this.targetId, this.expression);
    }

    public final ImmutableValidationDisabledUpdateCommand withTriggers(Iterable<? extends Trigger<ErrorState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableValidationDisabledUpdateCommand(this, (ImmutableList<Trigger<ErrorState>>)newValue, this.targetId, this.expression);
    }

    public final ImmutableValidationDisabledUpdateCommand withTargetId(ErrorId value) {
        if (this.targetId == value) {
            return this;
        }
        ErrorId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableValidationDisabledUpdateCommand(this, this.triggers, newValue, this.expression);
    }

    public final ImmutableValidationDisabledUpdateCommand withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableValidationDisabledUpdateCommand(this, this.triggers, this.targetId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidationDisabledUpdateCommand && this.equalsByValue((ImmutableValidationDisabledUpdateCommand)another);
    }

    private boolean equalsByValue(ImmutableValidationDisabledUpdateCommand another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && this.expression.equals(another.expression);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + this.expression.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValidationDisabledUpdateCommand").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("expression", (Object)this.expression).toString();
    }

    public static ImmutableValidationDisabledUpdateCommand of(ErrorId targetId, Expression expression, List<Trigger<ErrorState>> triggers) {
        return ImmutableValidationDisabledUpdateCommand.of(targetId, expression, triggers);
    }

    public static ImmutableValidationDisabledUpdateCommand of(ErrorId targetId, Expression expression, Iterable<? extends Trigger<ErrorState>> triggers) {
        return new ImmutableValidationDisabledUpdateCommand(targetId, expression, triggers);
    }

    public static ImmutableValidationDisabledUpdateCommand copyOf(ValidationDisabledUpdateCommand instance) {
        if (instance instanceof ImmutableValidationDisabledUpdateCommand) {
            return (ImmutableValidationDisabledUpdateCommand)instance;
        }
        return ImmutableValidationDisabledUpdateCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValidationDisabledUpdateCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private static final long INIT_BIT_EXPRESSION = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<Trigger<ErrorState>> triggers = ImmutableList.builder();
        @Nullable
        private ErrorId targetId;
        @Nullable
        private Expression expression;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErrorUpdateCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ValidationDisabledUpdateCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ErrorUpdateCommand instance;
            long bits = 0L;
            if (object instanceof ErrorUpdateCommand) {
                instance = (ErrorUpdateCommand)object;
                if ((bits & 1L) == 0L) {
                    this.expression(instance.getExpression());
                    bits |= 1L;
                }
            }
            if (object instanceof ValidationDisabledUpdateCommand) {
                instance = (ValidationDisabledUpdateCommand)object;
                this.targetId((ErrorId)instance.getTargetId());
                this.addAllTriggers(instance.getTriggers());
                if ((bits & 1L) == 0L) {
                    this.expression(instance.getExpression());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ErrorState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ErrorState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ErrorState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ErrorState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ErrorId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableValidationDisabledUpdateCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidationDisabledUpdateCommand(null, (ImmutableList<Trigger<ErrorState>>)this.triggers.build(), this.targetId, this.expression);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expression");
            }
            return "Cannot build ValidationDisabledUpdateCommand, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

