/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.StaticTrigger;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.event.Event;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StaticTrigger", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableStaticTrigger<T>
implements StaticTrigger<T> {
    private final BiPredicate<T, T> when;
    private final ImmutableList<Event> allEvents;

    private ImmutableStaticTrigger(BiPredicate<T, T> when) {
        this.when = Objects.requireNonNull(when, "when");
        this.allEvents = ImmutableList.of();
    }

    private ImmutableStaticTrigger(BiPredicate<T, T> when, ImmutableList<Event> allEvents) {
        this.when = when;
        this.allEvents = allEvents;
    }

    @Override
    public BiPredicate<T, T> getWhen() {
        return this.when;
    }

    public ImmutableList<Event> getAllEvents() {
        return this.allEvents;
    }

    public final ImmutableStaticTrigger<T> withWhen(BiPredicate<T, T> value) {
        if (this.when == value) {
            return this;
        }
        BiPredicate<T, T> newValue = Objects.requireNonNull(value, "when");
        return new ImmutableStaticTrigger<T>(newValue, this.allEvents);
    }

    public final ImmutableStaticTrigger<T> withAllEvents(Event ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableStaticTrigger<T>(this.when, (ImmutableList<Event>)newValue);
    }

    public final ImmutableStaticTrigger<T> withAllEvents(Iterable<? extends Event> elements) {
        if (this.allEvents == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableStaticTrigger<T>(this.when, (ImmutableList<Event>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStaticTrigger && this.equalsByValue((ImmutableStaticTrigger)another);
    }

    private boolean equalsByValue(ImmutableStaticTrigger<?> another) {
        return this.when.equals(another.when) && this.allEvents.equals(another.allEvents);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.when.hashCode();
        h += (h << 5) + this.allEvents.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StaticTrigger").omitNullValues().add("when", this.when).add("allEvents", this.allEvents).toString();
    }

    public static <T> ImmutableStaticTrigger<T> of(BiPredicate<T, T> when) {
        return new ImmutableStaticTrigger<T>(when);
    }

    public static <T> ImmutableStaticTrigger<T> copyOf(StaticTrigger<T> instance) {
        if (instance instanceof ImmutableStaticTrigger) {
            return (ImmutableStaticTrigger)instance;
        }
        return ImmutableStaticTrigger.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="StaticTrigger", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_WHEN = 1L;
        private long initBits = 1L;
        @Nullable
        private BiPredicate<T, T> when;
        private ImmutableList.Builder<Event> allEvents = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(StaticTrigger<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Trigger<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Trigger instance;
            long bits = 0L;
            if (object instanceof StaticTrigger) {
                instance = (StaticTrigger)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAllEvents(instance.getAllEvents());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.when(instance.getWhen());
                    bits |= 2L;
                }
            }
            if (object instanceof Trigger) {
                instance = (Trigger)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAllEvents(instance.getAllEvents());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.when(instance.getWhen());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> when(BiPredicate<T, T> when) {
            this.when = Objects.requireNonNull(when, "when");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addAllEvents(Event element) {
            this.allEvents.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addAllEvents(Event ... elements) {
            this.allEvents.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> allEvents(Iterable<? extends Event> elements) {
            this.allEvents = ImmutableList.builder();
            return this.addAllAllEvents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<T> addAllAllEvents(Iterable<? extends Event> elements) {
            this.allEvents.addAll(elements);
            return this;
        }

        public ImmutableStaticTrigger<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStaticTrigger<T>(this.when, (ImmutableList<Event>)this.allEvents.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("when");
            }
            return "Cannot build StaticTrigger, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

