/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.SetRows;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SetRows", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSetRows
implements SetRows {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;
    private final ImmutableList<BigInteger> ids;

    private ImmutableSetRows(ItemId targetId, Iterable<? extends BigInteger> ids, Iterable<? extends Trigger<ItemState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.ids = ImmutableList.copyOf(ids);
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableSetRows(ImmutableSetRows original, ImmutableList<Trigger<ItemState>> triggers, ItemId targetId, ImmutableList<BigInteger> ids) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.ids = ids;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    public ImmutableList<BigInteger> getIds() {
        return this.ids;
    }

    @SafeVarargs
    public final ImmutableSetRows withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSetRows(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.ids);
    }

    public final ImmutableSetRows withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSetRows(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.ids);
    }

    public final ImmutableSetRows withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableSetRows(this, this.triggers, newValue, this.ids);
    }

    public final ImmutableSetRows withIds(BigInteger ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSetRows(this, this.triggers, this.targetId, (ImmutableList<BigInteger>)newValue);
    }

    public final ImmutableSetRows withIds(Iterable<? extends BigInteger> elements) {
        if (this.ids == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSetRows(this, this.triggers, this.targetId, (ImmutableList<BigInteger>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetRows && this.equalsByValue((ImmutableSetRows)another);
    }

    private boolean equalsByValue(ImmutableSetRows another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && this.ids.equals(another.ids);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + this.ids.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SetRows").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("ids", this.ids).toString();
    }

    public static ImmutableSetRows of(ItemId targetId, List<BigInteger> ids, List<Trigger<ItemState>> triggers) {
        return ImmutableSetRows.of(targetId, ids, triggers);
    }

    public static ImmutableSetRows of(ItemId targetId, Iterable<? extends BigInteger> ids, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableSetRows(targetId, ids, triggers);
    }

    public static ImmutableSetRows copyOf(SetRows instance) {
        if (instance instanceof ImmutableSetRows) {
            return (ImmutableSetRows)instance;
        }
        return ImmutableSetRows.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetRows", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;
        private ImmutableList.Builder<BigInteger> ids = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SetRows instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ItemId)instance.getTargetId());
            this.addAllIds(instance.getIds());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIds(BigInteger element) {
            this.ids.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIds(BigInteger ... elements) {
            this.ids.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ids(Iterable<? extends BigInteger> elements) {
            this.ids = ImmutableList.builder();
            return this.addAllIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllIds(Iterable<? extends BigInteger> elements) {
            this.ids.addAll(elements);
            return this;
        }

        public ImmutableSetRows build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetRows(null, (ImmutableList<Trigger<ItemState>>)this.triggers.build(), this.targetId, (ImmutableList<BigInteger>)this.ids.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            return "Cannot build SetRows, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

