/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.SetLocale;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SetLocale", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSetLocale
implements SetLocale {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;
    @Nullable
    private final String locale;

    private ImmutableSetLocale(@Nullable String locale, Iterable<? extends Trigger<ItemState>> triggers) {
        this.locale = locale;
        this.triggers = ImmutableList.copyOf(triggers);
        this.targetId = Objects.requireNonNull(SetLocale.super.getTargetId(), "targetId");
    }

    private ImmutableSetLocale(Builder builder) {
        this.triggers = builder.triggers.build();
        this.locale = builder.locale;
        this.targetId = builder.targetId != null ? builder.targetId : Objects.requireNonNull(SetLocale.super.getTargetId(), "targetId");
    }

    private ImmutableSetLocale(ImmutableList<Trigger<ItemState>> triggers, ItemId targetId, @Nullable String locale) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.locale = locale;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @Override
    @Nullable
    public String getLocale() {
        return this.locale;
    }

    @SafeVarargs
    public final ImmutableSetLocale withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSetLocale((ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.locale);
    }

    public final ImmutableSetLocale withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSetLocale((ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.locale);
    }

    public final ImmutableSetLocale withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableSetLocale(this.triggers, newValue, this.locale);
    }

    public final ImmutableSetLocale withLocale(@Nullable String value) {
        if (Objects.equals(this.locale, value)) {
            return this;
        }
        return new ImmutableSetLocale(this.triggers, this.targetId, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetLocale && this.equalsByValue((ImmutableSetLocale)another);
    }

    private boolean equalsByValue(ImmutableSetLocale another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && Objects.equals(this.locale, another.locale);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + Objects.hashCode(this.locale);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SetLocale").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("locale", (Object)this.locale).toString();
    }

    public static ImmutableSetLocale of(@Nullable String locale, List<Trigger<ItemState>> triggers) {
        return ImmutableSetLocale.of(locale, triggers);
    }

    public static ImmutableSetLocale of(@Nullable String locale, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableSetLocale(locale, triggers);
    }

    public static ImmutableSetLocale copyOf(SetLocale instance) {
        if (instance instanceof ImmutableSetLocale) {
            return (ImmutableSetLocale)instance;
        }
        return ImmutableSetLocale.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetLocale", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @javax.annotation.Nullable
        private ItemId targetId;
        @javax.annotation.Nullable
        private String locale;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SetLocale instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId(instance.getTargetId());
            String localeValue = instance.getLocale();
            if (localeValue != null) {
                this.locale(localeValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder locale(@Nullable String locale) {
            this.locale = locale;
            return this;
        }

        public ImmutableSetLocale build() {
            return new ImmutableSetLocale(this);
        }
    }
}

