/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.AbstractPageCommand;
import io.dialob.session.engine.session.command.NextPage;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NextPage", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableNextPage
implements NextPage {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;

    private ImmutableNextPage(Iterable<? extends Trigger<ItemState>> triggers) {
        this.triggers = ImmutableList.copyOf(triggers);
        this.targetId = Objects.requireNonNull(NextPage.super.getTargetId(), "targetId");
    }

    private ImmutableNextPage(Builder builder) {
        this.triggers = builder.triggers.build();
        this.targetId = builder.targetId != null ? builder.targetId : Objects.requireNonNull(NextPage.super.getTargetId(), "targetId");
    }

    private ImmutableNextPage(ImmutableList<Trigger<ItemState>> triggers, ItemId targetId) {
        this.triggers = triggers;
        this.targetId = targetId;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @SafeVarargs
    public final ImmutableNextPage withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNextPage((ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableNextPage withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNextPage((ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableNextPage withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableNextPage(this.triggers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNextPage && this.equalsByValue((ImmutableNextPage)another);
    }

    private boolean equalsByValue(ImmutableNextPage another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NextPage").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).toString();
    }

    public static ImmutableNextPage of(List<Trigger<ItemState>> triggers) {
        return ImmutableNextPage.of(triggers);
    }

    public static ImmutableNextPage of(Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableNextPage(triggers);
    }

    public static ImmutableNextPage copyOf(NextPage instance) {
        if (instance instanceof ImmutableNextPage) {
            return (ImmutableNextPage)instance;
        }
        return ImmutableNextPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NextPage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NextPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractPageCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            AbstractPageCommand instance;
            long bits = 0L;
            if (object instanceof NextPage) {
                instance = (NextPage)object;
                if ((bits & 1L) == 0L) {
                    this.targetId(instance.getTargetId());
                    bits |= 1L;
                }
                this.addAllTriggers(instance.getTriggers());
            }
            if (object instanceof AbstractPageCommand) {
                instance = (AbstractPageCommand)object;
                if ((bits & 1L) == 0L) {
                    this.targetId(instance.getTargetId());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            return this;
        }

        public ImmutableNextPage build() {
            return new ImmutableNextPage(this);
        }
    }
}

