/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.ImmutableEventMatchers;
import io.dialob.session.engine.session.command.event.ActivePageUpdatedEvent;
import io.dialob.session.engine.session.command.event.ActiveUpdatedEvent;
import io.dialob.session.engine.session.command.event.AnsweredUpdatedEvent;
import io.dialob.session.engine.session.command.event.AnyInvalidAnswersUpdatedEvent;
import io.dialob.session.engine.session.command.event.AttributeEvent;
import io.dialob.session.engine.session.command.event.AvailableItemsUpdatedEvent;
import io.dialob.session.engine.session.command.event.DisabledUpdatedEvent;
import io.dialob.session.engine.session.command.event.ErrorActiveUpdatedEvent;
import io.dialob.session.engine.session.command.event.ErrorEvent;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.command.event.ItemAddedEvent;
import io.dialob.session.engine.session.command.event.ItemRemovedEvent;
import io.dialob.session.engine.session.command.event.ItemsChangedEvent;
import io.dialob.session.engine.session.command.event.RequiredUpdatedEvent;
import io.dialob.session.engine.session.command.event.RowCanBeRemovedUpdatedEvent;
import io.dialob.session.engine.session.command.event.RowGroupItemsInitEvent;
import io.dialob.session.engine.session.command.event.RowsCanBeAddedUpdatedEvent;
import io.dialob.session.engine.session.command.event.SessionLocaleUpdatedEvent;
import io.dialob.session.engine.session.command.event.TargetEvent;
import io.dialob.session.engine.session.command.event.ValidUpdatedEvent;
import io.dialob.session.engine.session.command.event.ValueSetUpdatedEvent;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ValueSetId;
import org.immutables.value.Value;

@Value.Enclosing
public final class EventMatchers {
    private static final ImmutableEventMatchers.ActivePageEventMatcher ACTIVE_PAGE_EVENT_MATCHER = ImmutableEventMatchers.ActivePageEventMatcher.builder().build();
    private static final ImmutableEventMatchers.AvailableItemsEventMatcher AVAILABLE_ITEMS_EVENT_MATCHER = ImmutableEventMatchers.AvailableItemsEventMatcher.builder().build();
    private static final ImmutableEventMatchers.AnyErrorEventMatcher ANY_ERROR_EVENT_MATCHER = ImmutableEventMatchers.AnyErrorEventMatcher.builder().build();

    private EventMatchers() {
    }

    public static ErrorEventMatcher anyError() {
        return ANY_ERROR_EVENT_MATCHER;
    }

    public static ErrorEventMatcher error(@NonNull ErrorId errorId) {
        return ImmutableEventMatchers.ErrorIdEventMatcher.of(errorId);
    }

    public static ErrorEventMatcher targetError(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.TargetErrorEventMatcher.of(itemId);
    }

    public static EventMatcher whenActiveUpdated(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.IsActiveTargetEventMatcher.of(itemId);
    }

    public static EventMatcher whenValueUpdated(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.TargetIdEventMatcher.of(itemId);
    }

    public static EventMatcher whenRequiredUpdated(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.IsRequiredTargetEventMatcher.of(itemId);
    }

    public static EventMatcher whenDisabledUpdatedEvent(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.IsDisabledTargetEventMatcher.of(itemId);
    }

    public static EventMatcher whenRowsCanBeAddedUpdatedEvent(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher.builder().build();
    }

    public static EventMatcher whenRowCanBeRemovedUpdatedEvent(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher.builder().build();
    }

    public static EventMatcher whenValidUpdated(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.IsValidTargetEventMatcher.of(itemId);
    }

    public static EventMatcher whenAnyInvalidAnswersUpdated() {
        return ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher.builder().build();
    }

    public static EventMatcher whenActivePageUpdated() {
        return ACTIVE_PAGE_EVENT_MATCHER;
    }

    public static EventMatcher whenAvailableItemsUpdated() {
        return AVAILABLE_ITEMS_EVENT_MATCHER;
    }

    public static EventMatcher whenAnsweredUpdated(@NonNull ItemId itemId) {
        return ImmutableEventMatchers.AnsweredTargetEventMatcher.of(itemId);
    }

    public static EventMatcher whenItemsChanged(@NonNull ItemId groupId) {
        return ImmutableEventMatchers.ItemsChangedEventMatcher.of(groupId);
    }

    public static EventMatcher whenItemAdded(@NonNull ItemId prototypeId) {
        return ImmutableEventMatchers.ItemAddedEventMatcher.of(prototypeId);
    }

    public static EventMatcher whenItemRemoved(@NonNull ItemId prototypeId) {
        return ImmutableEventMatchers.ItemRemovedEventMatcher.of(prototypeId);
    }

    public static EventMatcher whenRowGroupItemsInit(@NonNull ItemId prototypeId) {
        return ImmutableEventMatchers.RowGroupItemsInitEventMatcher.of(prototypeId);
    }

    public static EventMatcher errorActivity(@NonNull ErrorEventMatcher errorEventMatcher) {
        return ImmutableEventMatchers.ErrorActivityEventMatcher.of(errorEventMatcher);
    }

    public static EventMatcher whenValueSetUpdated(@NonNull ValueSetId valueSetId) {
        return ImmutableEventMatchers.ValueSetUpdatedEventMatcher.of(valueSetId);
    }

    public static EventMatcher whenSessionLocaleUpdated() {
        return event -> event instanceof SessionLocaleUpdatedEvent;
    }

    static interface ErrorEventMatcher
    extends EventMatcher {
    }

    @Value.Immutable
    static interface ValueSetUpdatedEventMatcher
    extends ValueSetEventMatcher {
        @Override
        default public boolean matches(Event event) {
            if (event instanceof ValueSetUpdatedEvent) {
                ValueSetUpdatedEvent targetEvent = (ValueSetUpdatedEvent)event;
                return this.getValueSetId().equals(targetEvent.getValueSetId());
            }
            return false;
        }
    }

    static interface ValueSetEventMatcher
    extends EventMatcher {
        @Value.Parameter
        public ValueSetId getValueSetId();
    }

    @Value.Immutable
    static interface ErrorActivityEventMatcher
    extends ErrorEventMatcher {
        @Value.Parameter
        public ErrorEventMatcher getErrorEventMatcher();

        @Override
        default public boolean matches(Event event) {
            if (event instanceof ErrorEvent) {
                ErrorActiveUpdatedEvent targetEvent = (ErrorActiveUpdatedEvent)event;
                return this.getErrorEventMatcher().matches(targetEvent);
            }
            return false;
        }
    }

    @Value.Immutable
    static interface ErrorIdEventMatcher
    extends ErrorEventMatcher {
        @Value.Parameter
        public ErrorId getErrorId();

        @Override
        default public boolean matches(Event event) {
            if (event instanceof ErrorEvent) {
                ErrorEvent targetEvent = (ErrorEvent)event;
                return this.getErrorId().equals(targetEvent.getErrorId());
            }
            return false;
        }
    }

    @Value.Immutable
    static interface TargetErrorEventMatcher
    extends ErrorEventMatcher {
        @Value.Parameter
        public ItemId getTargetId();

        @Override
        default public boolean matches(Event event) {
            if (event instanceof ErrorEvent) {
                ErrorEvent errorEvent = (ErrorEvent)event;
                return this.getTargetId().equals(errorEvent.getErrorId().getItemId());
            }
            return false;
        }
    }

    @Value.Immutable
    static interface AnyErrorEventMatcher
    extends ErrorEventMatcher {
        @Override
        default public boolean matches(Event event) {
            return event instanceof ErrorEvent;
        }
    }

    @Value.Immutable
    static interface AvailableItemsEventMatcher
    extends QuestionnaireEventMatcher {
        @Override
        default public boolean matches(Event event) {
            return event instanceof AvailableItemsUpdatedEvent;
        }
    }

    @Value.Immutable(prehash=true)
    static interface ActivePageEventMatcher
    extends QuestionnaireEventMatcher {
        @Override
        default public boolean matches(Event event) {
            return event instanceof ActivePageUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface AnsweredTargetEventMatcher
    extends AttributeEventMatcher<AnsweredUpdatedEvent> {
        @Override
        default public boolean eventTypeMatches(Event event) {
            return event instanceof AnsweredUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface ItemsChangedEventMatcher
    extends AttributeEventMatcher<ItemsChangedEvent> {
        @Override
        default public boolean eventTypeMatches(Event event) {
            return event instanceof ItemsChangedEvent;
        }
    }

    @Value.Immutable
    static interface RowCanBeRemovedUpdatedEventMatcher
    extends EventMatcher {
        @Override
        default public boolean matches(Event event) {
            return event instanceof RowCanBeRemovedUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface RowsCanBeAddedUpdatedEventMatcher
    extends EventMatcher {
        @Override
        default public boolean matches(Event event) {
            return event instanceof RowsCanBeAddedUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface RowGroupItemsInitEventMatcher
    extends EventMatcher {
        @Value.Parameter
        public ItemId getPrototypeId();

        @Override
        default public boolean matches(Event event) {
            RowGroupItemsInitEvent rgiie;
            return event instanceof RowGroupItemsInitEvent && (rgiie = (RowGroupItemsInitEvent)event).getPrototypeId().equals(this.getPrototypeId());
        }
    }

    @Value.Immutable
    static interface ItemRemovedEventMatcher
    extends EventMatcher {
        @Value.Parameter
        public ItemId getPrototypeId();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        default public boolean matches(Event event) {
            if (!(event instanceof ItemRemovedEvent)) return false;
            ItemRemovedEvent ire = (ItemRemovedEvent)event;
            if (!IdUtils.matches(this.getPrototypeId(), ire.getRemoveItemId())) return false;
            return true;
        }
    }

    @Value.Immutable
    static interface ItemAddedEventMatcher
    extends EventMatcher {
        @Value.Parameter
        public ItemId getPrototypeId();

        @Override
        default public boolean matches(Event event) {
            ItemAddedEvent iae;
            return event instanceof ItemAddedEvent && (iae = (ItemAddedEvent)event).getPrototypeId().equals(this.getPrototypeId());
        }
    }

    @Value.Immutable
    static interface AnyInvalidAnswersUpdatedEventMatcher
    extends EventMatcher {
        @Override
        default public boolean matches(Event event) {
            return event instanceof AnyInvalidAnswersUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface IsValidTargetEventMatcher
    extends AttributeEventMatcher<ValidUpdatedEvent> {
        @Override
        default public boolean eventTypeMatches(Event event) {
            return event instanceof ValidUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface IsDisabledTargetEventMatcher
    extends AttributeEventMatcher<DisabledUpdatedEvent> {
        @Override
        default public boolean eventTypeMatches(Event event) {
            return event instanceof DisabledUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface IsRequiredTargetEventMatcher
    extends AttributeEventMatcher<ActiveUpdatedEvent> {
        @Override
        default public boolean eventTypeMatches(Event event) {
            return event instanceof RequiredUpdatedEvent;
        }
    }

    @Value.Immutable
    static interface IsActiveTargetEventMatcher
    extends AttributeEventMatcher<ActiveUpdatedEvent> {
        @Override
        default public boolean eventTypeMatches(Event event) {
            return event instanceof ActiveUpdatedEvent;
        }
    }

    static interface AttributeEventMatcher<E extends AttributeEvent>
    extends EventMatcher {
        @Value.Parameter
        public ItemId getTargetMatcher();

        public boolean eventTypeMatches(Event var1);

        @Override
        default public boolean matches(Event event) {
            if (this.eventTypeMatches(event)) {
                AttributeEvent attributeEvent = (AttributeEvent)event;
                TargetEvent targetEvent = attributeEvent.getTarget();
                return IdUtils.matches(this.getTargetMatcher(), targetEvent.getTargetId());
            }
            return false;
        }
    }

    static interface QuestionnaireEventMatcher
    extends EventMatcher {
    }

    @Value.Immutable
    public static interface TargetIdEventMatcher
    extends EventMatcher {
        @Value.Parameter
        public ItemId getTargetId();

        @Override
        default public boolean matches(Event event) {
            if (event instanceof TargetEvent) {
                TargetEvent targetEvent = (TargetEvent)event;
                return IdUtils.matches(this.getTargetId(), targetEvent.getTargetId());
            }
            return false;
        }
    }
}

