/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.SessionUpdateCommand;
import io.dialob.session.engine.session.model.ImmutableItemStates;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface CreateRowGroupFromPrototypeCommand
extends SessionUpdateCommand {
    @Value.Parameter
    public ItemId getItemPrototypeId();

    @Override
    @NonNull
    default public ItemStates update(@NonNull EvalContext context, @NonNull ItemStates itemStates) {
        return this.getItemPrototypeId().getParent().flatMap(groupId -> {
            Set<ItemId> currentItems = Set.copyOf(itemStates.getItemStates().get(groupId).getItems());
            Set originalItems = context.getOriginalItemState((ItemId)groupId).map(state -> Set.copyOf(state.getItems())).orElse(Set.of());
            Sets.SetView newItems = Sets.difference(currentItems, originalItems);
            Sets.SetView removedItems = Sets.difference(originalItems, currentItems);
            return context.findPrototype(this.getItemPrototypeId()).map(prototypeState -> ImmutableItemStates.builder().from(itemStates).itemStates(itemStates.getItemStates().values().stream().filter(item -> !removedItems.contains((Object)item.getId())).collect(Collectors.toMap(itemState -> Objects.requireNonNull(itemState.getId()), item -> item))).putAllItemStates(newItems.stream().map(prototypeState::withId).collect(Collectors.toMap(ItemState::getId, item -> item))).build());
        }).orElse(itemStates);
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEventMatchers() {
        return this.getItemPrototypeId().getParent().map(EventMatchers::whenItemsChanged).map(Set::of).orElseGet(Set::of);
    }
}

