/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.Collections;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface ValueSetToListOperator
extends Expression {
    @Value.Parameter
    public ValueSetId getValueSetId();

    @Override
    @Nullable
    default public Object eval(@NonNull EvalContext context) {
        return context.getValueSetState(this.getValueSetId()).map(valueSetState -> valueSetState.getEntries().stream().map(ValueSetState.Entry::getId).toList()).orElseGet(Collections::emptyList);
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.arrayOf((ValueType)ValueType.STRING);
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return Set.of(EventMatchers.whenValueSetUpdated(this.getValueSetId()));
    }
}

