/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface ValueSetEntryToStringOperator
extends Expression {
    @Value.Parameter
    public ValueSetId getValueSetId();

    @Value.Parameter
    public Expression getExpression();

    @Override
    @Nullable
    default public String eval(@NonNull EvalContext context) {
        Object eval = this.getExpression().eval(context);
        if (eval == null) {
            return null;
        }
        Optional<ValueSetState> valueSetState = context.getValueSetState(this.getValueSetId());
        return valueSetState.map(valueSetState1 -> {
            if (eval instanceof String) {
                String string = (String)eval;
                for (ValueSetState.Entry entry2 : valueSetState1.getEntries()) {
                    if (!entry2.getId().equals(eval)) continue;
                    return entry2.getLabel();
                }
                return string;
            }
            if (eval instanceof List) {
                List list = (List)eval;
                return valueSetState1.getEntries().stream().filter(entry -> list.contains(entry.getId())).map(entry -> entry.getLabel()).collect(Collectors.joining(", "));
            }
            return null;
        }).orElse(null);
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        HashSet<EventMatcher> deps = new HashSet<EventMatcher>(this.getExpression().getEvalRequiredConditions());
        deps.add(EventMatchers.whenValueSetUpdated(this.getValueSetId()));
        return deps;
    }
}

