/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.ItemId;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface IsOnLastPage
extends Expression {
    @Override
    default public Boolean eval(@NonNull EvalContext context) {
        return context.getItemState(DialobSession.QUESTIONNAIRE_REF).map(questionnaire -> questionnaire.getActivePage().map(activePage -> {
            List<ItemId> availableItems = questionnaire.getAvailableItems();
            if (availableItems.size() <= 1) {
                return true;
            }
            int i = availableItems.indexOf(activePage);
            return i == availableItems.size() - 1;
        }).orElse(false)).orElse(false);
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return Set.of(EventMatchers.whenActivePageUpdated(), EventMatchers.whenAvailableItemsUpdated());
    }
}

