/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ItemId;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface IsBlankOperator
extends Expression {
    public ItemId getQuestionId();

    @Override
    default public Boolean eval(@NonNull EvalContext evalContext) {
        return evalContext.getItemState(this.getQuestionId()).map(itemState -> itemState.isBlank() && itemState.isActive()).orElse(false);
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return Set.of(EventMatchers.whenAnsweredUpdated(this.getQuestionId()), EventMatchers.whenActiveUpdated(this.getQuestionId()));
    }
}

