/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.expr.arith.StringTemplateOperator;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StringTemplateOperator", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableStringTemplateOperator
implements StringTemplateOperator {
    private final String template;
    private final ImmutableSet<EventMatcher> evalRequiredConditions;

    private ImmutableStringTemplateOperator(String template, ImmutableSet<EventMatcher> evalRequiredConditions) {
        this.template = template;
        this.evalRequiredConditions = evalRequiredConditions;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public ImmutableSet<EventMatcher> getEvalRequiredConditions() {
        return this.evalRequiredConditions;
    }

    public final ImmutableStringTemplateOperator withTemplate(String value) {
        String newValue = Objects.requireNonNull(value, "template");
        if (this.template.equals(newValue)) {
            return this;
        }
        return new ImmutableStringTemplateOperator(newValue, this.evalRequiredConditions);
    }

    public final ImmutableStringTemplateOperator withEvalRequiredConditions(EventMatcher ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableStringTemplateOperator(this.template, (ImmutableSet<EventMatcher>)newValue);
    }

    public final ImmutableStringTemplateOperator withEvalRequiredConditions(Iterable<? extends EventMatcher> elements) {
        if (this.evalRequiredConditions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableStringTemplateOperator(this.template, (ImmutableSet<EventMatcher>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStringTemplateOperator && this.equalsByValue((ImmutableStringTemplateOperator)another);
    }

    private boolean equalsByValue(ImmutableStringTemplateOperator another) {
        return this.template.equals(another.template) && this.evalRequiredConditions.equals(another.evalRequiredConditions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.template.hashCode();
        h += (h << 5) + this.evalRequiredConditions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StringTemplateOperator").omitNullValues().add("template", (Object)this.template).add("evalRequiredConditions", this.evalRequiredConditions).toString();
    }

    public static ImmutableStringTemplateOperator copyOf(StringTemplateOperator instance) {
        if (instance instanceof ImmutableStringTemplateOperator) {
            return (ImmutableStringTemplateOperator)instance;
        }
        return ImmutableStringTemplateOperator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StringTemplateOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEMPLATE = 1L;
        private long initBits = 1L;
        @Nullable
        private String template;
        private ImmutableSet.Builder<EventMatcher> evalRequiredConditions = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StringTemplateOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Expression instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Expression instance;
            long bits = 0L;
            if (object instanceof StringTemplateOperator) {
                instance = (StringTemplateOperator)object;
                this.template(instance.getTemplate());
                if ((bits & 1L) == 0L) {
                    this.addAllEvalRequiredConditions(instance.getEvalRequiredConditions());
                    bits |= 1L;
                }
            }
            if (object instanceof Expression) {
                instance = (Expression)object;
                if ((bits & 1L) == 0L) {
                    this.addAllEvalRequiredConditions(instance.getEvalRequiredConditions());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder template(String template) {
            this.template = Objects.requireNonNull(template, "template");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvalRequiredConditions(EventMatcher element) {
            this.evalRequiredConditions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvalRequiredConditions(EventMatcher ... elements) {
            this.evalRequiredConditions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder evalRequiredConditions(Iterable<? extends EventMatcher> elements) {
            this.evalRequiredConditions = ImmutableSet.builder();
            return this.addAllEvalRequiredConditions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEvalRequiredConditions(Iterable<? extends EventMatcher> elements) {
            this.evalRequiredConditions.addAll(elements);
            return this;
        }

        public ImmutableStringTemplateOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStringTemplateOperator(this.template, (ImmutableSet<EventMatcher>)this.evalRequiredConditions.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("template");
            }
            return "Cannot build StringTemplateOperator, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

