/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.expr.arith.Pair;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Pair", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutablePair<L, R>
implements Pair<L, R> {
    private final L left;
    private final R right;

    private ImmutablePair(L left, R right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    private ImmutablePair(ImmutablePair<L, R> original, L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    public final ImmutablePair<L, R> withLeft(L value) {
        if (this.left == value) {
            return this;
        }
        L newValue = Objects.requireNonNull(value, "left");
        return new ImmutablePair<L, R>(this, newValue, this.right);
    }

    public final ImmutablePair<L, R> withRight(R value) {
        if (this.right == value) {
            return this;
        }
        R newValue = Objects.requireNonNull(value, "right");
        return new ImmutablePair<L, R>(this, this.left, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePair && this.equalsByValue((ImmutablePair)another);
    }

    private boolean equalsByValue(ImmutablePair<?, ?> another) {
        return this.left.equals(another.left) && this.right.equals(another.right);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Pair").omitNullValues().add("left", this.left).add("right", this.right).toString();
    }

    public static <L, R> ImmutablePair<L, R> of(L left, R right) {
        return new ImmutablePair<L, R>(left, right);
    }

    public static <L, R> ImmutablePair<L, R> copyOf(Pair<L, R> instance) {
        if (instance instanceof ImmutablePair) {
            return (ImmutablePair)instance;
        }
        return ImmutablePair.builder().from(instance).build();
    }

    public static <L, R> Builder<L, R> builder() {
        return new Builder();
    }

    @Generated(from="Pair", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<L, R> {
        private static final long INIT_BIT_LEFT = 1L;
        private static final long INIT_BIT_RIGHT = 2L;
        private long initBits = 3L;
        @Nullable
        private L left;
        @Nullable
        private R right;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<L, R> from(Pair<L, R> instance) {
            Objects.requireNonNull(instance, "instance");
            this.left(instance.getLeft());
            this.right(instance.getRight());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<L, R> left(L left) {
            this.left = Objects.requireNonNull(left, "left");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<L, R> right(R right) {
            this.right = Objects.requireNonNull(right, "right");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePair<L, R> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePair<L, R>(null, this.left, this.right);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("left");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("right");
            }
            return "Cannot build Pair, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

