/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.expr.arith.BinaryOperator;
import io.dialob.session.engine.program.expr.arith.Reducer;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BinaryOperator", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableBinaryOperator<T>
implements BinaryOperator<T> {
    private final ImmutableList<Expression> nodes;
    private final Reducer<T> reducer;

    private ImmutableBinaryOperator(ImmutableList<Expression> nodes, Reducer<T> reducer) {
        this.nodes = nodes;
        this.reducer = reducer;
    }

    public ImmutableList<Expression> getNodes() {
        return this.nodes;
    }

    @Override
    public Reducer<T> getReducer() {
        return this.reducer;
    }

    public final ImmutableBinaryOperator<T> withNodes(Expression ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBinaryOperator<T>((ImmutableList<Expression>)newValue, this.reducer);
    }

    public final ImmutableBinaryOperator<T> withNodes(Iterable<? extends Expression> elements) {
        if (this.nodes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBinaryOperator<T>((ImmutableList<Expression>)newValue, this.reducer);
    }

    public final ImmutableBinaryOperator<T> withReducer(Reducer<T> value) {
        if (this.reducer == value) {
            return this;
        }
        Reducer<T> newValue = Objects.requireNonNull(value, "reducer");
        return new ImmutableBinaryOperator<T>(this.nodes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBinaryOperator && this.equalsByValue((ImmutableBinaryOperator)another);
    }

    private boolean equalsByValue(ImmutableBinaryOperator<?> another) {
        return this.nodes.equals(another.nodes) && this.reducer.equals(another.reducer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodes.hashCode();
        h += (h << 5) + this.reducer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BinaryOperator").omitNullValues().add("nodes", this.nodes).add("reducer", this.reducer).toString();
    }

    public static <T> ImmutableBinaryOperator<T> copyOf(BinaryOperator<T> instance) {
        if (instance instanceof ImmutableBinaryOperator) {
            return (ImmutableBinaryOperator)instance;
        }
        return ImmutableBinaryOperator.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="BinaryOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_REDUCER = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Expression> nodes = ImmutableList.builder();
        @Nullable
        private Reducer<T> reducer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(BinaryOperator<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllNodes(instance.getNodes());
            this.reducer(instance.getReducer());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addNodes(Expression element) {
            this.nodes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addNodes(Expression ... elements) {
            this.nodes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> nodes(Iterable<? extends Expression> elements) {
            this.nodes = ImmutableList.builder();
            return this.addAllNodes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<T> addAllNodes(Iterable<? extends Expression> elements) {
            this.nodes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> reducer(Reducer<T> reducer) {
            this.reducer = Objects.requireNonNull(reducer, "reducer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBinaryOperator<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBinaryOperator<T>((ImmutableList<Expression>)this.nodes.build(), this.reducer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reducer");
            }
            return "Cannot build BinaryOperator, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

