/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ItemId;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface CountArrayLengthOperator
extends Expression {
    public ItemId getItemId();

    @Override
    default public BigInteger eval(@NonNull EvalContext evalContext) {
        return evalContext.getItemState(this.getItemId()).map(itemState -> {
            Object value = itemState.getValue();
            if (value == null) {
                return BigInteger.ZERO;
            }
            if (value.getClass().isArray()) {
                return BigInteger.valueOf(((Object[])value).length);
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return BigInteger.valueOf(collection.size());
            }
            return BigInteger.ZERO;
        }).orElse(BigInteger.ZERO);
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return Set.of(EventMatchers.whenValueUpdated(this.getItemId()));
    }
}

