/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface CoerceToDecimalOperator
extends Expression {
    @Value.Parameter
    public Expression getExpression();

    @Override
    default public BigDecimal eval(@NonNull EvalContext context) {
        Object eval;
        Object object = eval = this.getExpression().eval(context);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, Double.class, Number.class, String.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                BigDecimal decimal;
                yield decimal = (BigDecimal)object;
            }
            case 1 -> {
                Double double1 = (Double)object;
                yield BigDecimal.valueOf(double1);
            }
            case 2 -> {
                Number number = (Number)object;
                yield BigDecimal.valueOf(number.longValue());
            }
            case 3 -> {
                String string = (String)object;
                yield new BigDecimal(string);
            }
            default -> throw new IllegalStateException("Cannot coerce " + String.valueOf(eval) + " to decimal");
        };
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.DECIMAL;
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getExpression().getEvalRequiredConditions();
    }
}

