/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.expr.arith.Reducer;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface BinaryOperator<T>
extends Expression {
    public List<Expression> getNodes();

    public Reducer<T> getReducer();

    default public T eval(@NonNull EvalContext evalContext) {
        Object result = null;
        for (Expression node : this.getNodes()) {
            Object value = node.eval(evalContext);
            if (value == null) {
                return null;
            }
            if (result == null) {
                result = value;
                continue;
            }
            result = this.getReducer().apply(result, value);
        }
        return (T)result;
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return this.getReducer().getValueType();
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        HashSet<EventMatcher> deps = new HashSet<EventMatcher>();
        for (Expression expression : this.getNodes()) {
            deps.addAll(expression.getEvalRequiredConditions());
        }
        return deps;
    }
}

