/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.CannotCoerceTypeException;
import io.dialob.session.engine.program.expr.CannotNegateTypeException;
import io.dialob.session.engine.program.expr.CannotReduceTypeWithOperatorException;
import io.dialob.session.engine.program.expr.ImmutableExpressionList;
import io.dialob.session.engine.program.expr.MatcherRegexErrorException;
import io.dialob.session.engine.program.expr.OperatorFactory;
import io.dialob.session.engine.program.expr.OperatorSymbol;
import io.dialob.session.engine.program.expr.TypesDoNotHaveRelationException;
import io.dialob.session.engine.program.expr.arith.ArrayReducerOperator;
import io.dialob.session.engine.program.expr.arith.BooleanOperators;
import io.dialob.session.engine.program.expr.arith.Constant;
import io.dialob.session.engine.program.expr.arith.DateOperators;
import io.dialob.session.engine.program.expr.arith.DecimalOperators;
import io.dialob.session.engine.program.expr.arith.DurationOperators;
import io.dialob.session.engine.program.expr.arith.ImmutableArrayReducerOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableBinaryOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableCoerceToDecimalOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableCollectRowFieldsOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableCountArrayLengthOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableFunctionCallOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableInOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsValidOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableMatchesOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableNegOperatorDecimal;
import io.dialob.session.engine.program.expr.arith.ImmutableNegOperatorNumber;
import io.dialob.session.engine.program.expr.arith.ImmutableNotOperator;
import io.dialob.session.engine.program.expr.arith.NumberOperators;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.expr.arith.PeriodOperators;
import io.dialob.session.engine.program.expr.arith.Reducers;
import io.dialob.session.engine.program.expr.arith.StringOperators;
import io.dialob.session.engine.program.expr.arith.TimeOperators;
import io.dialob.session.engine.program.expr.arith.VariableReference;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import java.io.Serializable;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DDRLOperatorFactory
implements OperatorFactory {
    private static final DecimalOperators DECIMAL_OPERATORS = new DecimalOperators();
    private static final NumberOperators NUMBER_OPERATORS = new NumberOperators();
    private static final DateOperators DATE_OPERATORS = new DateOperators();
    private static final TimeOperators TIME_OPERATORS = new TimeOperators();
    private static final StringOperators STRING_OPERATORS = new StringOperators();
    private static final PeriodOperators PERIOD_OPERATORS = new PeriodOperators();
    private static final DurationOperators DURATION_OPERATORS = new DurationOperators();
    private static final BooleanOperators BOOLEAN_OPERATORS = new BooleanOperators();

    @NonNull
    private Operators operatorsOf(ValueType valueType) {
        if (valueType == ValueType.STRING) {
            return STRING_OPERATORS;
        }
        if (valueType == ValueType.DECIMAL) {
            return DECIMAL_OPERATORS;
        }
        if (valueType == ValueType.INTEGER) {
            return NUMBER_OPERATORS;
        }
        if (valueType == ValueType.TIME) {
            return TIME_OPERATORS;
        }
        if (valueType == ValueType.DATE) {
            return DATE_OPERATORS;
        }
        if (valueType == ValueType.PERIOD) {
            return PERIOD_OPERATORS;
        }
        if (valueType == ValueType.DURATION) {
            return DURATION_OPERATORS;
        }
        if (valueType == ValueType.BOOLEAN) {
            return BOOLEAN_OPERATORS;
        }
        throw new RuntimeException("Unknown type " + String.valueOf(valueType));
    }

    @Override
    @NonNull
    public Expression createOperator(@NonNull ValueType nodeValueType, @NonNull String operator, @NonNull List<Expression> arguments) {
        Expression expr;
        Expression rhs;
        Expression lhs;
        Expression op;
        OperatorSymbol operatorSymbol = OperatorSymbol.mapOp(operator);
        if (operatorSymbol == null) {
            return this.createFunctionInvocation(nodeValueType, operator, arguments);
        }
        if (arguments.size() == 2 && (op = TimeOperators.createOperator(operatorSymbol, lhs = this.lhs(arguments), rhs = this.rhs(arguments))) != null) {
            return op;
        }
        switch (operatorSymbol) {
            case PLUS: {
                return ImmutableBinaryOperator.builder().addAllNodes(this.coerceToType(nodeValueType, arguments)).reducer(Reducers.ofType(nodeValueType).add()).build();
            }
            case MINUS: {
                return ImmutableBinaryOperator.builder().addAllNodes(this.coerceToType(nodeValueType, arguments)).reducer(Reducers.ofType(nodeValueType).sub()).build();
            }
            case MULT: {
                return ImmutableBinaryOperator.builder().addAllNodes(this.coerceToType(nodeValueType, arguments)).reducer(Reducers.ofType(nodeValueType).mult()).build();
            }
            case DIV: {
                return ImmutableBinaryOperator.builder().addAllNodes(this.coerceToType(nodeValueType, arguments)).reducer(Reducers.ofType(nodeValueType).div()).build();
            }
            case NEG: {
                if (nodeValueType == ValueType.DECIMAL) {
                    return ImmutableNegOperatorDecimal.builder().expression(this.unaryArg(arguments)).build();
                }
                if (nodeValueType == ValueType.INTEGER) {
                    return ImmutableNegOperatorNumber.builder().expression(this.unaryArg(arguments)).build();
                }
                throw new CannotNegateTypeException(nodeValueType);
            }
            case NOT: {
                assert (arguments.size() == 1);
                assert (nodeValueType == ValueType.BOOLEAN);
                expr = this.unaryArg(arguments);
                break;
            }
            case AND: {
                return ImmutableBinaryOperator.builder().addAllNodes(this.coerceToType(ValueType.BOOLEAN, arguments)).reducer(Reducers.Bool.AND).build();
            }
            case OR: {
                return ImmutableBinaryOperator.builder().addAllNodes(this.coerceToType(ValueType.BOOLEAN, arguments)).reducer(Reducers.Bool.OR).build();
            }
            case NE: 
            case EQ: 
            case LT: 
            case LE: 
            case GE: 
            case GT: {
                return this.relationOf(operatorSymbol, this.lhs(arguments), this.rhs(arguments));
            }
            case NOT_IN: 
            case IN: {
                expr = ImmutableInOperator.builder().lhs(this.first(arguments)).rhs(ImmutableExpressionList.builder().addAllExpressions(this.rest(arguments)).build()).build();
                break;
            }
            case NOT_MATCHES: 
            case MATCHES: {
                Expression patternExpr = this.rhs(arguments);
                this.validateRegexExpression(patternExpr);
                expr = ImmutableMatchesOperator.builder().lhs(this.lhs(arguments)).rhs(patternExpr).build();
                break;
            }
            case NOT_ANSWERED: 
            case ANSWERED: {
                expr = Operators.isAnswered(this.varRef(arguments));
                break;
            }
            case NOT_BLANK: 
            case BLANK: {
                expr = Operators.isBlank(this.varRef(arguments));
                break;
            }
            case NOT_NULL: 
            case NULL: {
                expr = Operators.isNull(this.varRef(arguments));
                break;
            }
            case COUNT: {
                expr = ImmutableCountArrayLengthOperator.builder().itemId(this.varRef(arguments)).build();
                break;
            }
            case NOT_VALID: 
            case VALID: {
                expr = ImmutableIsValidOperator.of(this.varRef(arguments));
                break;
            }
            case SUM: 
            case MIN: 
            case MAX: 
            case ALL: 
            case ANY: {
                expr = this.createArrayReducingOperator(operatorSymbol, nodeValueType, this.varRef(arguments));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot handle operator " + String.valueOf((Object)operatorSymbol));
            }
        }
        if (operatorSymbol.isNot()) {
            return ImmutableNotOperator.builder().expression(expr).build();
        }
        return expr;
    }

    private Expression createArrayReducingOperator(OperatorSymbol operatorSymbol, ValueType itemValueType, ItemId varRef) {
        BinaryOperator<Serializable> reducer;
        switch (operatorSymbol) {
            case SUM: {
                BinaryOperator<Serializable> binaryOperator = ArrayReducerOperator.sumOp(itemValueType);
                break;
            }
            case MIN: {
                BinaryOperator<Serializable> binaryOperator = ArrayReducerOperator.minOp(itemValueType);
                break;
            }
            case MAX: {
                BinaryOperator<Serializable> binaryOperator = ArrayReducerOperator.maxOp(itemValueType);
                break;
            }
            case ALL: {
                BinaryOperator<Serializable> binaryOperator = ArrayReducerOperator.allOp(itemValueType);
                break;
            }
            case ANY: {
                BinaryOperator<Serializable> binaryOperator = ArrayReducerOperator.anyOp(itemValueType);
                break;
            }
            default: {
                BinaryOperator<Serializable> binaryOperator = reducer = null;
            }
        }
        if (reducer == null) {
            throw new CannotReduceTypeWithOperatorException(operatorSymbol.name(), itemValueType);
        }
        return ImmutableArrayReducerOperator.of(reducer, ImmutableCollectRowFieldsOperator.of(varRef, itemValueType));
    }

    protected Expression validateRegexExpression(Expression patternExpr) {
        if (patternExpr instanceof Constant) {
            Constant constant = (Constant)patternExpr;
            try {
                Pattern.compile((String)constant.getValue());
            }
            catch (PatternSyntaxException pse) {
                throw new MatcherRegexErrorException("MATCHER_REGEX_SYNTAX_ERROR", (String)constant.getValue());
            }
        } else {
            throw new MatcherRegexErrorException("MATCHER_DYNAMIC_REGEX", null);
        }
        return patternExpr;
    }

    @NonNull
    private Expression createFunctionInvocation(@NonNull ValueType nodeValueType, @NonNull String operator, @NonNull List<Expression> arguments) {
        return ImmutableFunctionCallOperator.builder().valueType(nodeValueType).addAllArgs(arguments).functionName(operator).build();
    }

    private Iterable<? extends Expression> coerceToType(ValueType nodeValueType, List<Expression> arguments) {
        return arguments.stream().map(argument -> this.coerceToType(nodeValueType, (Expression)argument)).toList();
    }

    private Expression coerceToType(ValueType nodeValueType, Expression argument) {
        if (nodeValueType == argument.getValueType()) {
            return argument;
        }
        if (nodeValueType == ValueType.DECIMAL) {
            return ImmutableCoerceToDecimalOperator.builder().expression(argument).build();
        }
        throw new CannotCoerceTypeException(argument.getValueType(), nodeValueType);
    }

    private Expression first(List<Expression> expressions) {
        assert (!expressions.isEmpty());
        return expressions.getFirst();
    }

    private List<Expression> rest(List<Expression> expressions) {
        return expressions.stream().skip(1L).toList();
    }

    private Expression relationOf(OperatorSymbol operator, Expression lhs, Expression rhs) {
        ValueType leftValueType = lhs.getValueType();
        ValueType rightValueType = rhs.getValueType();
        ValueType coercedType = leftValueType;
        if (leftValueType != rightValueType) {
            coercedType = this.resolveCoersionTarget(leftValueType, rightValueType);
            lhs = this.coerceToType(coercedType, lhs);
            rhs = this.coerceToType(coercedType, rhs);
        }
        Operators operators = this.operatorsOf(coercedType);
        return switch (operator) {
            case OperatorSymbol.NE -> operators.ne(lhs, rhs);
            case OperatorSymbol.EQ -> operators.eq(lhs, rhs);
            case OperatorSymbol.LT -> operators.lt(lhs, rhs);
            case OperatorSymbol.LE -> operators.le(lhs, rhs);
            case OperatorSymbol.GE -> operators.ge(lhs, rhs);
            case OperatorSymbol.GT -> operators.gt(lhs, rhs);
            default -> throw new RuntimeException("Unknown operator " + String.valueOf((Object)operator));
        };
    }

    @NonNull
    private ValueType resolveCoersionTarget(ValueType leftValueType, ValueType rightValueType) {
        if (leftValueType.canOrderWith(rightValueType)) {
            return leftValueType.minusType(rightValueType);
        }
        if (leftValueType.canEqualWith(rightValueType)) {
            return leftValueType;
        }
        if (rightValueType.canEqualWith(leftValueType)) {
            return rightValueType;
        }
        throw new TypesDoNotHaveRelationException("NO_RELATION", leftValueType, rightValueType);
    }

    private Expression unaryArg(List<Expression> arguments) {
        assert (arguments.size() == 1);
        return arguments.getFirst();
    }

    private ItemId varRef(List<Expression> arguments) {
        assert (arguments.size() == 1);
        Expression expression = arguments.getFirst();
        assert (expression instanceof VariableReference);
        VariableReference variableReference = (VariableReference)expression;
        return variableReference.getItemId();
    }

    private Expression rhs(List<Expression> arguments) {
        assert (arguments.size() == 2);
        return arguments.get(1);
    }

    private Expression lhs(List<Expression> arguments) {
        assert (arguments.size() == 2);
        return arguments.getFirst();
    }
}

