/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.form.FormValidationError;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.AbstractItemBuilder;
import io.dialob.session.engine.program.BuilderParent;
import io.dialob.session.engine.program.GroupBuilder;
import io.dialob.session.engine.program.HasDefaultValue;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.ValidationBuilder;
import io.dialob.session.engine.program.expr.arith.BooleanOperators;
import io.dialob.session.engine.program.expr.arith.ImmutableConstant;
import io.dialob.session.engine.program.expr.arith.ImmutableEqOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableInOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIntersectionOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsActiveOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsDisabledOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsInactiveOrNullOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableSizeOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableValueSetToListOperator;
import io.dialob.session.engine.program.expr.arith.InfixOperator;
import io.dialob.session.engine.program.expr.arith.LocalizedLabelOperator;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.model.Error;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableError;
import io.dialob.session.engine.program.model.ImmutableFormItem;
import io.dialob.session.engine.program.model.ImmutableLabel;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ImmutableValueSetId;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemRef;
import io.dialob.session.engine.spi.AliasesProvider;
import io.dialob.session.engine.spi.ExpressionCompiler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableObject;

public class QuestionBuilder
extends AbstractItemBuilder<QuestionBuilder, ProgramBuilder>
implements ExpressionCompiler,
BuilderParent,
HasDefaultValue {
    public static final ImmutableLabel REQUIRED_LABEL = ImmutableLabel.builder().putLabels("fi", "T\u00e4yt\u00e4 puuttuva tieto.").putLabels("en", "Fill in the missing information.").putLabels("sv", "Fyll i uppgift som saknas.").build();
    public static final ImmutableLabel INVALID_SELECTION_LABEL = ImmutableLabel.builder().putLabels("fi", "Tarkista valinta.").putLabels("en", "Check the selection.").putLabels("sv", "Kontrollera valet.").build();
    private Object defaultValue;
    private String type;
    private String view;
    private String valueSetId;
    private List<Error> errors = new ArrayList<Error>();
    private List<ValidationBuilder> validationBuilders = new ArrayList<ValidationBuilder>();
    private Boolean required;
    private Expression requiredWhen;

    public QuestionBuilder(ProgramBuilder programBuilder, GroupBuilder hoistingGroupBuilder, String id) {
        super(programBuilder, programBuilder, hoistingGroupBuilder, id);
    }

    public ValidationBuilder addValidation(String errorCode) {
        ValidationBuilder validationBuilder = new ValidationBuilder(this, errorCode);
        this.validationBuilders.add(validationBuilder);
        return validationBuilder;
    }

    public QuestionBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public QuestionBuilder setView(String view) {
        this.view = view;
        return this;
    }

    public QuestionBuilder setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public QuestionBuilder setValueSet(String valueSetId) {
        this.valueSetId = valueSetId;
        return this;
    }

    @Override
    public Optional<ValueType> getValueType() {
        return Utils.mapQuestionTypeToValueType(this.type);
    }

    @Override
    protected void beforeExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        super.beforeExpressionCompilation(errorConsumer);
        this.getDefaultValue().map(defaultValue -> {
            if (this.getValueType().isEmpty()) {
                return Utils.createError(this.getIdStr(), "VALUE_TYPE_NOT_SET");
            }
            Utils.validateDefaultValue(this.getIdStr(), this.getValueType().get(), defaultValue, errorConsumer);
            return null;
        }).ifPresent(errorConsumer);
    }

    @Override
    protected void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        super.afterExpressionCompilation(errorConsumer);
        this.requireBooleanExpression(this.requiredWhen, FormValidationError.Type.REQUIREMENT, errorConsumer);
        Objects.requireNonNull(this.type, "type may not be null");
        ItemId id = this.getId();
        boolean prototype = this.getId().isPartial();
        Optional<GroupBuilder> hoistingGroup = this.getHoistingGroup();
        MutableObject disabledExpression = new MutableObject(BooleanOperators.TRUE);
        hoistingGroup.ifPresent(hoistingGroupBuilder -> disabledExpression.setValue((Object)ImmutableIsDisabledOperator.builder().itemId(hoistingGroupBuilder.getId()).build()));
        if (this.isRequiredDefined()) {
            this.createRequiredError(this::addError);
        }
        this.createNotValidSelectionError(this::addError);
        LocalizedLabelOperator labelOperator = this.createLabelOperator(this.label);
        LocalizedLabelOperator descriptionOperator = this.createLabelOperator(this.description);
        disabledExpression.setValue((Object)this.legacyNoteVisibility((Expression)disabledExpression.get(), labelOperator));
        hoistingGroup.ifPresent(hoistingGroupBuilder -> {
            this.activeWhen = this.activeWhen == BooleanOperators.TRUE ? ImmutableIsActiveOperator.builder().itemId(hoistingGroupBuilder.getId()).build() : Operators.and(ImmutableIsActiveOperator.builder().itemId(hoistingGroupBuilder.getId()).build(), this.activeWhen);
        });
        this.validationBuilders.forEach(validationBuilder -> validationBuilder.setPrototype(prototype));
        this.validationBuilders.forEach(validationBuilder -> validationBuilder.afterExpressionCompilation(errorConsumer));
        this.getProgramBuilder().addItem(ImmutableFormItem.builder().id(id).type(this.type).view(this.view).isPrototype(prototype).valueType(Utils.mapQuestionTypeToValueType(this.type).orElse(null)).activeExpression(this.activeWhen).requiredExpression(Optional.ofNullable(this.requiredWhen)).disabledExpression((Expression)disabledExpression.getValue()).className(ImmutableConstant.builder().value(this.classNames).valueType(ValueType.arrayOf((ValueType)ValueType.STRING)).build()).addAllErrors(this.errors).labelExpression(labelOperator).descriptionExpression(descriptionOperator).valueSetId(Optional.ofNullable(this.valueSetId)).defaultValue(Optional.ofNullable(this.defaultValue)).props(this.props).build());
    }

    private Expression legacyNoteVisibility(Expression disabledExpression, LocalizedLabelOperator labelOperator) {
        if ("note".equals(this.type)) {
            disabledExpression = Operators.or((Expression[])Stream.concat(labelOperator.getEvalRequiredConditions().stream(), Stream.of(disabledExpression)).filter(eventMatcher -> eventMatcher instanceof EventMatchers.TargetIdEventMatcher).map(eventMatcher -> (EventMatchers.TargetIdEventMatcher)eventMatcher).map(itemId -> this.getProgramBuilder().findDefaultValueForItem(itemId.getTargetId()).map(defaultValue -> BooleanOperators.FALSE).orElse(ImmutableIsInactiveOrNullOperator.of(itemId.getTargetId()))).filter(expression -> expression != BooleanOperators.FALSE).toArray(Expression[]::new));
        }
        return disabledExpression;
    }

    private boolean isRequiredDefined() {
        return this.required != null && this.required != false || this.requiredWhen != null;
    }

    private void createRequiredError(Consumer<Error> errorConsumer) {
        Expression expression = Operators.not(Operators.isAnswered(this.getId()));
        if (this.requiredWhen != null) {
            expression = Operators.and(expression, Operators.isRequired(this.getId()));
        }
        errorConsumer.accept(ImmutableError.builder().itemId(this.getId()).code("REQUIRED").isPrototype(this.getId().isPartial()).validationExpression(Operators.and(ImmutableIsActiveOperator.builder().itemId(this.getId()).build(), expression)).disabledExpression(ImmutableIsDisabledOperator.builder().itemId(this.getId()).build()).label(this.createLabelOperator(REQUIRED_LABEL)).build());
    }

    private void createNotValidSelectionError(Consumer<Error> errorConsumer) {
        if (this.valueSetId == null) {
            return;
        }
        InfixOperator check = "multichoice".equals(this.type) ? ImmutableEqOperator.builder().lhs(ImmutableSizeOperator.builder().expression(ImmutableIntersectionOperator.builder().lhs(Operators.var(this.getId(), ValueType.STRING)).rhs(ImmutableValueSetToListOperator.of(ImmutableValueSetId.of(this.valueSetId))).build()).build()).rhs(ImmutableSizeOperator.builder().expression(Operators.var(this.getId(), ValueType.STRING)).build()).build() : ImmutableInOperator.builder().lhs(Operators.var(this.getId(), ValueType.STRING)).rhs(ImmutableValueSetToListOperator.of(ImmutableValueSetId.of(this.valueSetId))).build();
        Expression expression = Operators.and(ImmutableIsActiveOperator.builder().itemId(this.getId()).build(), Operators.isAnswered(this.getId()), Operators.not(check));
        errorConsumer.accept(ImmutableError.builder().itemId(this.getId()).code("ERROR_INVALID_SELECTION").isPrototype(this.getId().isPartial()).validationExpression(expression).disabledExpression(ImmutableIsDisabledOperator.builder().itemId(this.getId()).build()).label(this.createLabelOperator(INVALID_SELECTION_LABEL)).build());
    }

    @Override
    public boolean compile(@NonNull ItemId itemId, @NonNull String expression, @NonNull AliasesProvider aliasesProvider, @NonNull Consumer<Expression> expressionConsumer, @NonNull FormValidationError.Type type, Optional<Integer> index) {
        return this.compileExpression(expression, aliasesProvider, expressionConsumer, type, index);
    }

    public void addError(Error error) {
        this.errors.add(error);
    }

    public QuestionBuilder setRequired(Boolean required) {
        this.required = required;
        this.requiredWhen = null;
        return this;
    }

    public QuestionBuilder setRequiredWhen(String requiredWhen) {
        if (requiredWhen != null) {
            this.compileExpression(requiredWhen, this, this::setRequiredWhen, FormValidationError.Type.REQUIREMENT, Optional.empty());
        }
        this.required = null;
        return this;
    }

    public QuestionBuilder setRequiredWhen(Expression requiredWhen) {
        this.requiredWhen = requiredWhen;
        this.required = null;
        return this;
    }

    public Optional<String> getValueSetId() {
        return Optional.ofNullable(this.valueSetId);
    }

    @Override
    public Optional<Object> getDefaultValue() {
        if ("note".equals(this.type)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public Map<String, ItemId> getAliases() {
        Map<String, ItemId> aliases = super.getAliases();
        if (this.getHoistingGroup().map(groupBuilder -> groupBuilder.getType() == GroupBuilder.Type.ROWGROUP).orElse(false).booleanValue()) {
            aliases = this.getHoistingGroup().map(GroupBuilder::getItemIds).map(itemIds -> itemIds.stream().collect(Collectors.toMap(itemId -> ((ItemRef)itemId).getId(), itemId -> itemId))).orElse(aliases);
        }
        return aliases;
    }
}

