/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.rule.parser.ParserUtil;
import io.dialob.rule.parser.api.RuleExpressionCompilerError;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.api.VariableNotDefinedException;
import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.DialobProgramBuildException;
import io.dialob.session.engine.program.AbstractItemBuilder;
import io.dialob.session.engine.program.Builder;
import io.dialob.session.engine.program.BuilderParent;
import io.dialob.session.engine.program.GroupBuilder;
import io.dialob.session.engine.program.HasDefaultValue;
import io.dialob.session.engine.program.ImmutableProgramBuilder;
import io.dialob.session.engine.program.QuestionBuilder;
import io.dialob.session.engine.program.ValueSetBuilder;
import io.dialob.session.engine.program.VariableBuilder;
import io.dialob.session.engine.program.ddrl.DDRLExpressionCompiler;
import io.dialob.session.engine.program.ddrl.UnknownValueTypeException;
import io.dialob.session.engine.program.expr.DDRLOperatorFactory;
import io.dialob.session.engine.program.expr.OperatorFactory;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableProgram;
import io.dialob.session.engine.program.model.ImmutableVariableItem;
import io.dialob.session.engine.program.model.Item;
import io.dialob.session.engine.program.model.Program;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.spi.AliasesProvider;
import io.dialob.session.engine.spi.ExpressionCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Enclosing
public class ProgramBuilder
implements ExpressionCompiler,
BuilderParent,
Builder<Program> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgramBuilder.class);
    private final FunctionRegistry functionRegistry;
    private final OperatorFactory operatorFactory;
    private String id;
    private Item rootItem;
    private final List<Item> items = new ArrayList<Item>();
    private final Map<ItemId, AbstractItemBuilder<?, ?>> types = new HashMap();
    private List<FormValidationError> errors = new ArrayList<FormValidationError>();
    private final List<ValueSet> valueSets = new ArrayList<ValueSet>();
    private final List<CompilableExpression> uncompiledExpressions = new ArrayList<CompilableExpression>();
    private List<AbstractItemBuilder<?, ProgramBuilder>> builders = new ArrayList();

    public ProgramBuilder(@NonNull FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
        this.operatorFactory = new DDRLOperatorFactory();
    }

    protected void addItem(Item item) {
        if ("questionnaire".equals(item.getType())) {
            assert (this.rootItem == null);
            this.rootItem = item;
        } else {
            this.items.add(item);
        }
    }

    public void add(ValueSet valueSet) {
        this.valueSets.add(valueSet);
    }

    public ProgramBuilder startProgram() {
        return this;
    }

    public ProgramBuilder setId(String id) {
        this.id = id;
        return this;
    }

    @NonNull
    private <T extends AbstractItemBuilder<?, ProgramBuilder>> T queue(@NonNull T itemBuilder) {
        this.builders.add(itemBuilder);
        return itemBuilder;
    }

    public Optional<String> findValueSetIdForItem(@NonNull ItemId itemId) {
        return this.findItemById(itemId).flatMap(abstractItemBuilder -> {
            if (abstractItemBuilder instanceof QuestionBuilder) {
                QuestionBuilder builder = (QuestionBuilder)abstractItemBuilder;
                return builder.getValueSetId();
            }
            return Optional.empty();
        });
    }

    public Optional<Object> findDefaultValueForItem(@NonNull ItemId itemId) {
        return this.findItemById(itemId).flatMap(abstractItemBuilder -> {
            if (abstractItemBuilder instanceof HasDefaultValue) {
                HasDefaultValue value = (HasDefaultValue)((Object)abstractItemBuilder);
                return value.getDefaultValue();
            }
            return Optional.empty();
        });
    }

    public Optional<AbstractItemBuilder<?, ?>> findItemById(@NonNull ItemId itemId) {
        for (AbstractItemBuilder<?, ProgramBuilder> item : this.builders) {
            if (!itemId.equals(item.getId())) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public GroupBuilder addRoot() {
        return this.queue(new GroupBuilder(this, null, "questionnaire").root());
    }

    public GroupBuilder addPage(String id) {
        return this.queue(new GroupBuilder(this, this.findHoistingGroup("questionnaire").orElse(null), id).page());
    }

    public GroupBuilder addGroup(String id) {
        return this.queue(new GroupBuilder(this, this.findHoistingGroup(id).orElse(null), id).group());
    }

    public GroupBuilder addSurveyGroup(String id) {
        return this.queue(new GroupBuilder(this, this.findHoistingGroup(id).orElse(null), id).surveyGroup());
    }

    public GroupBuilder addRowGroup(String id) {
        return this.queue(new GroupBuilder(this, this.findHoistingGroup(id).orElse(null), id).rowgroup());
    }

    public QuestionBuilder addQuestion(String id) {
        return this.queue(new QuestionBuilder(this, this.findHoistingGroup(id).orElse(null), id));
    }

    public VariableBuilder addVariable(String id) {
        return this.queue(new VariableBuilder(this, id));
    }

    public ValueSetBuilder addValueSet(String id) {
        return this.queue(new ValueSetBuilder(this, id));
    }

    @Override
    public boolean compile(@NonNull ItemId itemId, @NonNull String expression, @NonNull AliasesProvider aliasesProvider, @NonNull Consumer<Expression> expressionConsumer, @NonNull FormValidationError.Type type, Optional<Integer> index) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return false;
        }
        this.uncompiledExpressions.add(ImmutableProgramBuilder.CompilableExpression.of(itemId, expression, aliasesProvider, expressionConsumer, type, index));
        return true;
    }

    private boolean compileExpressions() {
        DDRLExpressionCompiler ddrlExpressionCompiler = this.createDdrlExpressionCompiler();
        int expressionCount = this.uncompiledExpressions.size();
        ArrayList errors = new ArrayList();
        while (expressionCount > 0) {
            errors.clear();
            this.uncompiledExpressions.removeIf(compilableExpression -> this.compileExpression(compilableExpression.getItemId().getParent().map(IdUtils::toString).orElse(null), ddrlExpressionCompiler, (CompilableExpression)compilableExpression, error -> errors.add(ImmutableFormValidationError.builder().itemId(IdUtils.toString(compilableExpression.getItemId())).type(compilableExpression.getType()).startIndex(error.getSpan().getStartIndex()).endIndex(error.getSpan().getStopIndex()).message(error.getErrorCode()).index(compilableExpression.getIndex()).build())).map(expr -> {
                compilableExpression.getExpressionConsumer().accept((Expression)expr);
                return true;
            }).orElse(false));
            if (this.uncompiledExpressions.size() == expressionCount) break;
            expressionCount = this.uncompiledExpressions.size();
        }
        if (!this.uncompiledExpressions.isEmpty()) {
            this.errors.addAll(errors);
            LOGGER.debug("Could not compile all expressions: {}", this.uncompiledExpressions);
            return false;
        }
        ddrlExpressionCompiler.getAsyncFunctionVariableExpressions().entrySet().forEach(stringExpressionEntry -> this.addItem(ImmutableVariableItem.builder().id(IdUtils.toId((String)stringExpressionEntry.getKey())).type("variable").isPrototype(false).isAsync(true).valueExpression((Expression)stringExpressionEntry.getValue()).build()));
        return true;
    }

    private DDRLExpressionCompiler createDdrlExpressionCompiler() {
        return new DDRLExpressionCompiler(this.operatorFactory);
    }

    private Optional<Expression> compileExpression(@NonNull String scope, @NonNull DDRLExpressionCompiler ddrlExpressionCompiler, @NonNull CompilableExpression compilableExpression, @NonNull Consumer<RuleExpressionCompilerError> errorConsumer) {
        try {
            ProgramVariableFinder variableFinder = new ProgramVariableFinder(compilableExpression.getAliasesProvider().getAliases(), scope);
            return ddrlExpressionCompiler.compile(variableFinder, compilableExpression.getExpression(), errorConsumer);
        }
        catch (UnknownValueTypeException e) {
            LOGGER.error("error: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public Program build() {
        Objects.requireNonNull(this.id, "id missing");
        this.builders.forEach(AbstractItemBuilder::setupId);
        this.types.clear();
        this.types.putAll(this.builders.stream().filter(builder -> {
            GroupBuilder gb;
            return builder instanceof QuestionBuilder || builder instanceof VariableBuilder || builder instanceof GroupBuilder && (gb = (GroupBuilder)builder).getType() == GroupBuilder.Type.ROWGROUP;
        }).collect(Collectors.toMap(AbstractItemBuilder::getId, builder -> builder)));
        this.beforeExpressionCompilation(this.errors::add);
        if (!this.compileExpressions()) {
            return null;
        }
        this.afterExpressionCompilation(this.errors::add);
        if (this.rootItem == null) {
            throw new DialobProgramBuildException("Form do not have root");
        }
        return ImmutableProgram.builder().id(this.id).rootItem(this.rootItem).items(this.items).valueSets(this.valueSets).build();
    }

    private void beforeExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        this.builders.forEach(programBuilderAbstractItemBuilder -> programBuilderAbstractItemBuilder.beforeExpressionCompilation(errorConsumer));
    }

    private void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        this.builders.forEach(programBuilderAbstractItemBuilder -> programBuilderAbstractItemBuilder.afterExpressionCompilation(errorConsumer));
    }

    public Optional<GroupBuilder> findHoistingGroup(String id) {
        for (AbstractItemBuilder<?, ProgramBuilder> builder : this.builders) {
            GroupBuilder groupBuilder;
            if (!(builder instanceof GroupBuilder) || !(groupBuilder = (GroupBuilder)builder).hoistsItem(id)) continue;
            return Optional.of(groupBuilder);
        }
        return Optional.empty();
    }

    public Optional<AbstractItemBuilder<?, ProgramBuilder>> findItemBuilder(@NonNull String id) {
        for (AbstractItemBuilder<?, ProgramBuilder> builder : this.builders) {
            if (!id.equals(builder.getIdStr())) continue;
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    public Optional<ItemId> findHoistingGroupId(String id) {
        return this.findHoistingGroup(id).map(AbstractItemBuilder::getId);
    }

    protected AbstractItemBuilder<?, ?> findVariable(@NonNull String variableName, boolean includePrototypes) {
        AbstractItemBuilder<?, ?> abstractItemBuilder = this.types.get(IdUtils.toId(variableName));
        if (abstractItemBuilder != null) {
            return abstractItemBuilder;
        }
        if (includePrototypes) {
            return this.types.keySet().stream().filter(itemId -> variableName.equals(itemId.getValue())).findFirst().map(this.types::get).orElse(null);
        }
        return null;
    }

    @Generated
    public List<FormValidationError> getErrors() {
        return this.errors;
    }

    private class ProgramVariableFinder
    implements VariableFinder {
        private final Map<String, ItemId> aliases;
        private String scope;

        private ProgramVariableFinder(Map<String, ItemId> aliases, String scope) {
            this.aliases = aliases;
            this.scope = scope;
        }

        private ProgramVariableFinder withScope(String scope) {
            return new ProgramVariableFinder(this.aliases, scope);
        }

        @Nullable
        public String getScope() {
            return this.scope;
        }

        public ValueType typeOf(String variableName) throws VariableNotDefinedException {
            Optional<ValueType> valueType;
            if (variableName.equals("language")) {
                return ValueType.STRING;
            }
            AbstractItemBuilder<?, ?> abstractItemBuilder = ProgramBuilder.this.findVariable(variableName, true);
            if (abstractItemBuilder != null && (valueType = abstractItemBuilder.getValueType()).isPresent()) {
                if (abstractItemBuilder.getId().isPartial() && !Objects.equals(this.scope, abstractItemBuilder.getId().getParent().map(IdUtils::toString).orElse(null))) {
                    return ValueType.arrayOf((ValueType)valueType.get());
                }
                return valueType.get();
            }
            throw new VariableNotDefinedException(variableName);
        }

        public Optional<String> findVariableScope(String variableName) {
            AbstractItemBuilder<?, ?> abstractItemBuilder = ProgramBuilder.this.findVariable(variableName, true);
            if (abstractItemBuilder == null) {
                return Optional.empty();
            }
            ItemId itemId = abstractItemBuilder.getId();
            return itemId.getParent().map(IdUtils::toString).filter(varScope -> !Objects.equals(this.scope, varScope));
        }

        @NonNull
        public String mapAlias(String aliasName) {
            if (this.aliases.containsKey(aliasName)) {
                return IdUtils.toString(this.aliases.get(aliasName));
            }
            return aliasName;
        }

        public ValueType returnTypeOf(String functionName, ValueType ... argTypes) throws VariableNotDefinedException {
            if (ParserUtil.isReducerOperator((String)functionName)) {
                if (argTypes[0] != null && argTypes[0].isArray()) {
                    return argTypes[0].getItemValueType();
                }
                return argTypes[0];
            }
            return ProgramBuilder.this.functionRegistry.returnTypeOf(functionName, argTypes);
        }

        public boolean isAsync(String functionName) {
            return ProgramBuilder.this.functionRegistry.isAsyncFunction(functionName);
        }
    }

    @Value.Immutable
    static interface CompilableExpression {
        @Value.Parameter
        public ItemId getItemId();

        @Value.Parameter
        public String getExpression();

        @Value.Parameter
        public AliasesProvider getAliasesProvider();

        @Value.Parameter
        public Consumer<Expression> getExpressionConsumer();

        @Value.Parameter
        public FormValidationError.Type getType();

        @Value.Parameter
        public Optional<Integer> getIndex();
    }
}

