/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ImmutableActionItem;
import io.dialob.api.proto.ImmutableValueSet;
import io.dialob.api.proto.ImmutableValueSetEntry;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.rule.parser.ParserUtil;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ValueSetState;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public final class Utils {
    private Utils() {
    }

    public static Optional<ValueType> mapQuestionTypeToValueType(String type) {
        if (type != null) {
            return Optional.ofNullable(switch (type) {
                case "text", "list", "survey" -> ValueType.STRING;
                case "boolean" -> ValueType.BOOLEAN;
                case "date" -> ValueType.DATE;
                case "time" -> ValueType.TIME;
                case "number" -> ValueType.INTEGER;
                case "decimal" -> ValueType.DECIMAL;
                case "multichoice" -> ValueType.arrayOf((ValueType)ValueType.STRING);
                case "rowgroup" -> ValueType.arrayOf((ValueType)ValueType.INTEGER);
                default -> null;
            });
        }
        return Optional.empty();
    }

    public static boolean isVariable(@NonNull String type) {
        return Utils.isProgramVariable(type) || Utils.isContextVariable(type);
    }

    public static boolean isContextVariable(@NonNull String type) {
        return "context".equals(type);
    }

    public static boolean isProgramVariable(@NonNull String type) {
        return "variable".equals(type);
    }

    public static boolean isNote(@NonNull String type) {
        return "note".equals(type);
    }

    public static boolean isRowgroup(@NonNull String type) {
        return "rowgroup".equals(type);
    }

    public static boolean isQuestionType(@NonNull ItemState itemState) {
        return switch (itemState.getType()) {
            case "questionnaire", "group", "note", "variable", "context", "surveygroup" -> false;
            case "rowgroup" -> {
                if (itemState.getPrototypeId() == null) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @Nullable
    public static Object parse(@NonNull String type, Object answer) {
        if (Utils.isVariable(type)) {
            return answer;
        }
        ValueType valueType = ParserUtil.itemTypeToValueType((String)type);
        if (valueType != null) {
            return Utils.parse(valueType, answer);
        }
        return null;
    }

    @Nullable
    public static Object parse(@NonNull ValueType valueType, Object value) {
        if (value == null) {
            return null;
        }
        if (!valueType.isArray()) {
            if (value instanceof String) {
                String string = (String)value;
                try {
                    return valueType.parseFromString(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return valueType.coerceFrom(value);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(item -> {
                Object object;
                if (item instanceof Integer) {
                    Integer i = (Integer)item;
                    object = BigInteger.valueOf(i.intValue());
                } else {
                    object = item;
                }
                return object;
            }).toList();
        }
        return null;
    }

    @NonNull
    public static ValueSet toValueSet(@NonNull ValueSetState valueSetState) {
        return ImmutableValueSet.builder().id(IdUtils.toString(valueSetState.getId())).entries(valueSetState.getEntries().stream().map(entry -> ImmutableValueSetEntry.builder().key(entry.getId()).value(entry.getLabel()).build()).toList()).build();
    }

    @NonNull
    public static Error toError(@NonNull ErrorState updated) {
        return ImmutableError.builder().id(IdUtils.toString(updated.getItemId())).code(updated.getCode()).description(updated.getLabel()).build();
    }

    @NonNull
    public static ActionItem toActionItem(@NonNull ItemState itemState, UnaryOperator<ImmutableActionItem.Builder> post) {
        Object value = Utils.isVariable(itemState.getType()) ? itemState.getValue() : itemState.getAnswer();
        ImmutableActionItem.Builder actionItemBuilder = ImmutableActionItem.builder().disabled(itemState.isDisabled() ? Boolean.valueOf(true) : null).inactive(!itemState.isActive() ? Boolean.valueOf(true) : null).activeItem((String)itemState.getActivePage().map(IdUtils::toString).orElse(null)).answered(Boolean.valueOf(itemState.isAnswered())).view(itemState.getView()).id(IdUtils.toString(itemState.getId())).type(itemState.getType()).value(value);
        if (itemState.isRequired()) {
            actionItemBuilder.required(Boolean.valueOf(true));
        }
        if (!itemState.getClassNames().isEmpty()) {
            actionItemBuilder.className(itemState.getClassNames());
        }
        if (!itemState.getItems().isEmpty()) {
            actionItemBuilder.items(itemState.getItems().stream().map(IdUtils::toString).toList());
        }
        actionItemBuilder.label(itemState.getLabel());
        actionItemBuilder.description(itemState.getDescription());
        if (!itemState.getAllowedActions().isEmpty()) {
            actionItemBuilder.allowedActions(itemState.getAllowedActions());
        }
        if (!itemState.getAvailableItems().isEmpty()) {
            actionItemBuilder.availableItems(itemState.getAvailableItems().stream().map(IdUtils::toString).toList());
        }
        itemState.getValueSetId().ifPresent(arg_0 -> ((ImmutableActionItem.Builder)actionItemBuilder).valueSetId(arg_0));
        if (post != null) {
            post.apply(actionItemBuilder);
        }
        return actionItemBuilder.build();
    }

    public static void writeNullableString(@NonNull CodedOutputStream output, String string) throws IOException {
        if (string == null) {
            output.writeBoolNoTag(false);
        } else {
            output.writeBoolNoTag(true);
            output.writeStringNoTag(string);
        }
    }

    @Nullable
    public static String readNullableString(@NonNull CodedInputStream input) throws IOException {
        if (input.readBool()) {
            return input.readString();
        }
        return null;
    }

    public static void writeNullableDate(@NonNull CodedOutputStream output, Date date) throws IOException {
        if (date == null) {
            output.writeBoolNoTag(false);
        } else {
            output.writeBoolNoTag(true);
            output.writeInt64NoTag(date.getTime());
        }
    }

    public static Date readNullableDate(@NonNull CodedInputStream input) throws IOException {
        if (input.readBool()) {
            return new Date(input.readInt64());
        }
        return null;
    }

    public static void writeObjectValue(@NonNull CodedOutputStream output, Object value) throws IOException {
        boolean present = value != null;
        output.writeBoolNoTag(present);
        if (present) {
            if (value instanceof String) {
                String string = (String)value;
                output.write((byte)1);
                output.writeStringNoTag(string);
            } else if (value instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)value;
                output.write((byte)2);
                Utils.writeBigInteger(output, bigInteger);
            } else if (value instanceof Boolean) {
                Boolean boolean1 = (Boolean)value;
                output.write((byte)3);
                output.writeBoolNoTag(boolean1.booleanValue());
            } else if (value instanceof Double) {
                Double double1 = (Double)value;
                output.write((byte)4);
                output.writeDoubleNoTag(double1.doubleValue());
            } else if (value instanceof List) {
                List listValue = (List)value;
                int size = listValue.size();
                if (size == 0) {
                    output.write((byte)-128);
                    return;
                }
                if (listValue.getFirst() instanceof String) {
                    output.write((byte)-127);
                    output.writeInt32NoTag(size);
                    for (String s : listValue) {
                        output.writeStringNoTag(s);
                    }
                } else if (listValue.getFirst() instanceof BigInteger) {
                    output.write((byte)-126);
                    output.writeInt32NoTag(size);
                    for (BigInteger i : listValue) {
                        Utils.writeBigInteger(output, i);
                    }
                }
            } else {
                throw new RuntimeException("Unknown answer value: " + String.valueOf(value.getClass()));
            }
        }
    }

    public static void writeBigInteger(@NonNull CodedOutputStream output, @NonNull BigInteger value) throws IOException {
        byte[] bytes = value.toByteArray();
        output.writeInt32NoTag(bytes.length);
        output.writeRawBytes(bytes);
    }

    public static Object readObjectValue(@NonNull CodedInputStream input) throws IOException {
        if (input.readBool()) {
            byte answerType = input.readRawByte();
            switch (answerType) {
                case 1: {
                    return input.readString();
                }
                case 2: {
                    return Utils.readBigInteger(input);
                }
                case 3: {
                    return input.readBool();
                }
                case 4: {
                    return input.readDouble();
                }
                case -128: {
                    return List.of();
                }
                case -127: {
                    int count = input.readInt32();
                    String[] strings = new String[count];
                    for (int i = 0; i < count; ++i) {
                        strings[i] = input.readString();
                    }
                    return List.of(strings);
                }
                case -126: {
                    int count = input.readInt32();
                    BigInteger[] integers = new BigInteger[count];
                    for (int i = 0; i < count; ++i) {
                        integers[i] = Utils.readBigInteger(input);
                    }
                    return List.of(integers);
                }
            }
        }
        return null;
    }

    public static BigInteger readBigInteger(@NonNull CodedInputStream input) throws IOException {
        int size = input.readInt32();
        byte[] bytes = input.readRawBytes(size);
        return new BigInteger(bytes);
    }

    public static Object validateDefaultValue(String id, ValueType valueType, Object value, Consumer<FormValidationError> errorListener) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String s = (String)value;
            try {
                return valueType.parseFromString(s);
            }
            catch (Exception e) {
                errorListener.accept(Utils.createError(id, "INVALID_DEFAULT_VALUE"));
                return null;
            }
        }
        if (value instanceof Boolean && valueType == ValueType.BOOLEAN) {
            return value;
        }
        if (value instanceof LocalDate && valueType == ValueType.DATE) {
            return value;
        }
        if (value instanceof LocalTime && valueType == ValueType.TIME) {
            return value;
        }
        if (value instanceof Period && valueType == ValueType.PERIOD) {
            return value;
        }
        if (value instanceof Duration && valueType == ValueType.DURATION) {
            return value;
        }
        if (value instanceof BigDecimal && valueType == ValueType.DECIMAL) {
            return value;
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            if (valueType == ValueType.INTEGER) {
                return BigInteger.valueOf(i.intValue());
            }
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            if (valueType == ValueType.INTEGER) {
                return BigInteger.valueOf(l);
            }
        }
        if (value instanceof Double) {
            Double aDouble = (Double)value;
            if (valueType == ValueType.DECIMAL) {
                return BigDecimal.valueOf(aDouble);
            }
        }
        errorListener.accept(Utils.createError(id, "INVALID_DEFAULT_VALUE"));
        return null;
    }

    public static FormValidationError createError(String itemId, String message) {
        return ImmutableFormValidationError.builder().type(FormValidationError.Type.GENERAL).level(FormValidationError.Level.ERROR).message(message).itemId(itemId).build();
    }
}

