/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine;

import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUtil {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugUtil.class);

    private static String stripImmutablePrefix(String name) {
        if (name.startsWith("Immutable")) {
            return name.substring(9);
        }
        return name;
    }

    public static String commandToString(Command<?> command) {
        String commandName = DebugUtil.stripImmutablePrefix(command.getClass().getSimpleName());
        if (command instanceof UpdateCommand) {
            UpdateCommand updateCommand = (UpdateCommand)command;
            return commandName + "(" + IdUtils.toString(updateCommand.getTargetId()) + ")";
        }
        return commandName;
    }

    public static void dumpDotFile(Map<ItemId, List<Command<?>>> itemCommands) {
        Set events = itemCommands.entrySet().stream().flatMap(commandEntry -> ((List)commandEntry.getValue()).stream().flatMap(command -> command.getTriggers().stream()).flatMap(trigger -> trigger.getAllEvents().stream()).map(event -> Pair.of((Object)((ItemId)commandEntry.getKey()), (Object)event))).collect(Collectors.toSet());
        HashMap eventToCommands = new HashMap();
        HashMap commandToEvent = new HashMap();
        itemCommands.values().stream().flatMap(Collection::stream).filter(c -> c instanceof UpdateCommand).map(c -> (UpdateCommand)c).forEach(command -> events.stream().filter(event -> command.getEventMatchers().stream().anyMatch(eventMatcher -> eventMatcher.matches((Event)event.getRight()))).forEach(event -> eventToCommands.computeIfAbsent(event, event1 -> new ArrayList()).add(command)));
        itemCommands.values().stream().flatMap(Collection::stream).filter(c -> c instanceof UpdateCommand).map(c -> (UpdateCommand)c).forEach(command -> command.getTriggers().forEach(trigger -> commandToEvent.computeIfAbsent(command, command1 -> new ArrayList()).addAll(trigger.getAllEvents().stream().map(e -> Pair.of(command.getTargetId(), (Object)e)).toList())));
        try (FileWriter writer = new FileWriter("deps.dot");){
            TreeSet<CallSite> nodes = new TreeSet<CallSite>();
            TreeSet<CallSite> edges = new TreeSet<CallSite>();
            writer.write("strict digraph {\n");
            for (Map.Entry entry : eventToCommands.entrySet()) {
                for (UpdateCommand command2 : (List)entry.getValue()) {
                    nodes.add((CallSite)((Object)(DebugUtil.commandToString(command2) + "\" [shape=rect]\n")));
                    edges.add((CallSite)((Object)(DebugUtil.eventName((Pair<ItemId, Event>)((Pair)entry.getKey())) + "\" -> \"" + DebugUtil.commandToString(command2) + "\"\n")));
                }
            }
            for (Map.Entry entry : commandToEvent.entrySet()) {
                nodes.add((CallSite)((Object)(DebugUtil.commandToString((Command)entry.getKey()) + "\" [shape=rect]\n")));
                for (Pair event : (List)entry.getValue()) {
                    edges.add((CallSite)((Object)(DebugUtil.commandToString((Command)entry.getKey()) + "\" -> \"" + DebugUtil.eventName((Pair<ItemId, Event>)event) + "\"\n")));
                }
            }
            nodes.forEach(s -> {
                try {
                    writer.write("  \"" + s);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            edges.forEach(s -> {
                try {
                    writer.write("  \"" + s);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            writer.write("}\n");
        }
        catch (IOException e) {
            LOGGER.error("dot dump failed.", (Throwable)e);
        }
    }

    private static String eventName(Pair<ItemId, Event> event) {
        return ((Event)event.getRight()).getClass().getSimpleName().substring(9) + "(" + IdUtils.toString((ItemId)event.getLeft()) + ")";
    }
}

