package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueSetId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueSetId.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueSetId.of()}.
 */
@Generated(from = "ValueSetId", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValueSetId implements ValueSetId {
  private final String valueSetId;

  private ImmutableValueSetId(String valueSetId) {
    this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
  }

  private ImmutableValueSetId(ImmutableValueSetId original, String valueSetId) {
    this.valueSetId = valueSetId;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @Override
  public String getValueSetId() {
    return valueSetId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSetId#getValueSetId() valueSetId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueSetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableValueSetId withValueSetId(String value) {
    String newValue = Objects.requireNonNull(value, "valueSetId");
    if (this.valueSetId.equals(newValue)) return this;
    return new ImmutableValueSetId(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueSetId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueSetId
        && equalsByValue((ImmutableValueSetId) another);
  }

  private boolean equalsByValue(ImmutableValueSetId another) {
    return valueSetId.equals(another.valueSetId);
  }

  /**
   * Computes a hash code from attributes: {@code valueSetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueSetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueSetId} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueSetId")
        .omitNullValues()
        .add("valueSetId", valueSetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code ValueSetId} instance.
   * @param valueSetId The value for the {@code valueSetId} attribute
   * @return An immutable ValueSetId instance
   */
  public static ImmutableValueSetId of(String valueSetId) {
    return new ImmutableValueSetId(valueSetId);
  }

  /**
   * Creates an immutable copy of a {@link ValueSetId} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueSetId instance
   */
  public static ImmutableValueSetId copyOf(ValueSetId instance) {
    if (instance instanceof ImmutableValueSetId) {
      return (ImmutableValueSetId) instance;
    }
    return ImmutableValueSetId.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueSetId ImmutableValueSetId}.
   * <pre>
   * ImmutableValueSetId.builder()
   *    .valueSetId(String) // required {@link ValueSetId#getValueSetId() valueSetId}
   *    .build();
   * </pre>
   * @return A new ImmutableValueSetId builder
   */
  public static ImmutableValueSetId.Builder builder() {
    return new ImmutableValueSetId.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueSetId ImmutableValueSetId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueSetId", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE_SET_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String valueSetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueSetId} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueSetId instance) {
      Objects.requireNonNull(instance, "instance");
      this.valueSetId(instance.getValueSetId());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSetId#getValueSetId() valueSetId} attribute.
     * @param valueSetId The value for valueSetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(String valueSetId) {
      this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
      initBits &= ~INIT_BIT_VALUE_SET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueSetId ImmutableValueSetId}.
     * @return An immutable instance of ValueSetId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueSetId build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueSetId(null, valueSetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE_SET_ID) != 0) attributes.add("valueSetId");
      return "Cannot build ValueSetId, some of required attributes are not set " + attributes;
    }
  }
}
