package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ItemStates}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemStates.builder()}.
 */
@Generated(from = "ItemStates", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemStates implements ItemStates {
  private final ImmutableMap<ItemId, ItemState> itemStates;
  private final ImmutableMap<ValueSetId, ValueSetState> valueSetStates;
  private final ImmutableMap<ErrorId, ErrorState> errorStates;

  private ImmutableItemStates(
      ImmutableMap<ItemId, ItemState> itemStates,
      ImmutableMap<ValueSetId, ValueSetState> valueSetStates,
      ImmutableMap<ErrorId, ErrorState> errorStates) {
    this.itemStates = itemStates;
    this.valueSetStates = valueSetStates;
    this.errorStates = errorStates;
  }

  /**
   * @return The value of the {@code itemStates} attribute
   */
  @Override
  public ImmutableMap<ItemId, ItemState> getItemStates() {
    return itemStates;
  }

  /**
   * @return The value of the {@code valueSetStates} attribute
   */
  @Override
  public ImmutableMap<ValueSetId, ValueSetState> getValueSetStates() {
    return valueSetStates;
  }

  /**
   * @return The value of the {@code errorStates} attribute
   */
  @Override
  public ImmutableMap<ErrorId, ErrorState> getErrorStates() {
    return errorStates;
  }

  /**
   * Copy the current immutable object by replacing the {@link ItemStates#getItemStates() itemStates} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the itemStates map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableItemStates withItemStates(Map<? extends ItemId, ? extends ItemState> entries) {
    if (this.itemStates == entries) return this;
    ImmutableMap<ItemId, ItemState> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableItemStates(newValue, this.valueSetStates, this.errorStates);
  }

  /**
   * Copy the current immutable object by replacing the {@link ItemStates#getValueSetStates() valueSetStates} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the valueSetStates map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableItemStates withValueSetStates(Map<? extends ValueSetId, ? extends ValueSetState> entries) {
    if (this.valueSetStates == entries) return this;
    ImmutableMap<ValueSetId, ValueSetState> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableItemStates(this.itemStates, newValue, this.errorStates);
  }

  /**
   * Copy the current immutable object by replacing the {@link ItemStates#getErrorStates() errorStates} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the errorStates map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableItemStates withErrorStates(Map<? extends ErrorId, ? extends ErrorState> entries) {
    if (this.errorStates == entries) return this;
    ImmutableMap<ErrorId, ErrorState> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableItemStates(this.itemStates, this.valueSetStates, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemStates} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemStates
        && equalsByValue((ImmutableItemStates) another);
  }

  private boolean equalsByValue(ImmutableItemStates another) {
    return itemStates.equals(another.itemStates)
        && valueSetStates.equals(another.valueSetStates)
        && errorStates.equals(another.errorStates);
  }

  /**
   * Computes a hash code from attributes: {@code itemStates}, {@code valueSetStates}, {@code errorStates}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + itemStates.hashCode();
    h += (h << 5) + valueSetStates.hashCode();
    h += (h << 5) + errorStates.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemStates} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ItemStates")
        .omitNullValues()
        .add("itemStates", itemStates)
        .add("valueSetStates", valueSetStates)
        .add("errorStates", errorStates)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ItemStates} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemStates instance
   */
  public static ImmutableItemStates copyOf(ItemStates instance) {
    if (instance instanceof ImmutableItemStates) {
      return (ImmutableItemStates) instance;
    }
    return ImmutableItemStates.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemStates ImmutableItemStates}.
   * <pre>
   * ImmutableItemStates.builder()
   *    .putItemStates|putAllItemStates(io.dialob.session.engine.session.model.ItemId =&gt; io.dialob.session.engine.session.model.ItemState) // {@link ItemStates#getItemStates() itemStates} mappings
   *    .putValueSetStates|putAllValueSetStates(io.dialob.session.engine.session.model.ValueSetId =&gt; io.dialob.session.engine.session.model.ValueSetState) // {@link ItemStates#getValueSetStates() valueSetStates} mappings
   *    .putErrorStates|putAllErrorStates(io.dialob.session.engine.session.model.ErrorId =&gt; io.dialob.session.engine.session.model.ErrorState) // {@link ItemStates#getErrorStates() errorStates} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableItemStates builder
   */
  public static ImmutableItemStates.Builder builder() {
    return new ImmutableItemStates.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemStates ImmutableItemStates}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemStates", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<ItemId, ItemState> itemStates = ImmutableMap.builder();
    private ImmutableMap.Builder<ValueSetId, ValueSetState> valueSetStates = ImmutableMap.builder();
    private ImmutableMap.Builder<ErrorId, ErrorState> errorStates = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemStates} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemStates instance) {
      Objects.requireNonNull(instance, "instance");
      putAllItemStates(instance.getItemStates());
      putAllValueSetStates(instance.getValueSetStates());
      putAllErrorStates(instance.getErrorStates());
      return this;
    }

    /**
     * Put one entry to the {@link ItemStates#getItemStates() itemStates} map.
     * @param key The key in the itemStates map
     * @param value The associated value in the itemStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putItemStates(ItemId key, ItemState value) {
      this.itemStates.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ItemStates#getItemStates() itemStates} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putItemStates(Map.Entry<? extends ItemId, ? extends ItemState> entry) {
      this.itemStates.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ItemStates#getItemStates() itemStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the itemStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemStates(Map<? extends ItemId, ? extends ItemState> entries) {
      this.itemStates = ImmutableMap.builder();
      return putAllItemStates(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ItemStates#getItemStates() itemStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the itemStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllItemStates(Map<? extends ItemId, ? extends ItemState> entries) {
      this.itemStates.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link ItemStates#getValueSetStates() valueSetStates} map.
     * @param key The key in the valueSetStates map
     * @param value The associated value in the valueSetStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValueSetStates(ValueSetId key, ValueSetState value) {
      this.valueSetStates.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ItemStates#getValueSetStates() valueSetStates} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValueSetStates(Map.Entry<? extends ValueSetId, ? extends ValueSetState> entry) {
      this.valueSetStates.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ItemStates#getValueSetStates() valueSetStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the valueSetStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetStates(Map<? extends ValueSetId, ? extends ValueSetState> entries) {
      this.valueSetStates = ImmutableMap.builder();
      return putAllValueSetStates(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ItemStates#getValueSetStates() valueSetStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the valueSetStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllValueSetStates(Map<? extends ValueSetId, ? extends ValueSetState> entries) {
      this.valueSetStates.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link ItemStates#getErrorStates() errorStates} map.
     * @param key The key in the errorStates map
     * @param value The associated value in the errorStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putErrorStates(ErrorId key, ErrorState value) {
      this.errorStates.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ItemStates#getErrorStates() errorStates} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putErrorStates(Map.Entry<? extends ErrorId, ? extends ErrorState> entry) {
      this.errorStates.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ItemStates#getErrorStates() errorStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the errorStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errorStates(Map<? extends ErrorId, ? extends ErrorState> entries) {
      this.errorStates = ImmutableMap.builder();
      return putAllErrorStates(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ItemStates#getErrorStates() errorStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the errorStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllErrorStates(Map<? extends ErrorId, ? extends ErrorState> entries) {
      this.errorStates.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemStates ImmutableItemStates}.
     * @return An immutable instance of ItemStates
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemStates build() {
      return new ImmutableItemStates(itemStates.build(), valueSetStates.build(), errorStates.build());
    }
  }
}
