package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ItemRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemRef.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableItemRef.of()}.
 */
@Generated(from = "ItemRef", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemRef implements ItemRef {
  private final @Nullable ItemId parent;
  private final String id;

  @SuppressWarnings("unchecked") // safe covariant cast
  private ImmutableItemRef(
      String id,
      Optional<? extends ItemId> parent) {
    this.id = Objects.requireNonNull(id, "id");
    this.parent = parent.orElse(null);
  }

  private ImmutableItemRef(
      ImmutableItemRef original,
      @Nullable ItemId parent,
      String id) {
    this.parent = parent;
    this.id = id;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @Override
  public Optional<ItemId> getParent() {
    return Optional.ofNullable(parent);
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link ItemRef#getParent() parent} attribute.
   * @param value The value for parent
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableItemRef withParent(ItemId value) {
    ItemId newValue = Objects.requireNonNull(value, "parent");
    if (this.parent == newValue) return this;
    return new ImmutableItemRef(this, newValue, this.id);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ItemRef#getParent() parent} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for parent
   * @return A modified copy or {@code this} if not changed
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableItemRef withParent(Optional<? extends ItemId> optional) {
    @Nullable ItemId value = optional.orElse(null);
    if (this.parent == value) return this;
    return new ImmutableItemRef(this, value, this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableItemRef withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableItemRef(this, this.parent, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemRef
        && equalsByValue((ImmutableItemRef) another);
  }

  private boolean equalsByValue(ImmutableItemRef another) {
    return Objects.equals(parent, another.parent)
        && id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code parent}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(parent);
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ItemRef")
        .omitNullValues()
        .add("parent", parent)
        .add("id", id)
        .toString();
  }

  /**
   * Construct a new immutable {@code ItemRef} instance.
   * @param id The value for the {@code id} attribute
   * @param parent The value for the {@code parent} attribute
   * @return An immutable ItemRef instance
   */
  public static ImmutableItemRef of(String id, Optional<? extends ItemId> parent) {
    return new ImmutableItemRef(id, parent);
  }

  /**
   * Creates an immutable copy of a {@link ItemRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemRef instance
   */
  public static ImmutableItemRef copyOf(ItemRef instance) {
    if (instance instanceof ImmutableItemRef) {
      return (ImmutableItemRef) instance;
    }
    return ImmutableItemRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemRef ImmutableItemRef}.
   * <pre>
   * ImmutableItemRef.builder()
   *    .parent(Optional&lt;io.dialob.session.engine.session.model.ItemId&gt;) // optional {@link ItemRef#getParent() parent}
   *    .id(String) // required {@link ItemRef#getId() id}
   *    .build();
   * </pre>
   * @return A new ImmutableItemRef builder
   */
  public static ImmutableItemRef.Builder builder() {
    return new ImmutableItemRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemRef ImmutableItemRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId parent;
    private @Nullable String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.model.ItemRef} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemRef instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.model.ItemId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemId instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof ItemRef) {
        ItemRef instance = (ItemRef) object;
        if ((bits & 0x1L) == 0) {
          Optional<ItemId> parentOptional = instance.getParent();
          if (parentOptional.isPresent()) {
            parent(parentOptional);
          }
          bits |= 0x1L;
        }
        this.id(instance.getId());
      }
      if (object instanceof ItemId) {
        ItemId instance = (ItemId) object;
        if ((bits & 0x1L) == 0) {
          Optional<ItemId> parentOptional = instance.getParent();
          if (parentOptional.isPresent()) {
            parent(parentOptional);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the optional value {@link ItemRef#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(ItemId parent) {
      this.parent = Objects.requireNonNull(parent, "parent");
      return this;
    }

    /**
     * Initializes the optional value {@link ItemRef#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(Optional<? extends ItemId> parent) {
      this.parent = parent.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemRef ImmutableItemRef}.
     * @return An immutable instance of ItemRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemRef(null, parent, id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ItemRef, some of required attributes are not set " + attributes;
    }
  }
}
