package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ItemIndex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemIndex.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableItemIndex.of()}.
 */
@Generated(from = "ItemIndex", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemIndex implements ItemIndex {
  private final @Nullable ItemId parent;
  private final Integer index;

  @SuppressWarnings("unchecked") // safe covariant cast
  private ImmutableItemIndex(
      Integer index,
      Optional<? extends ItemId> parent) {
    this.index = Objects.requireNonNull(index, "index");
    this.parent = parent.orElse(null);
  }

  private ImmutableItemIndex(
      ImmutableItemIndex original,
      @Nullable ItemId parent,
      Integer index) {
    this.parent = parent;
    this.index = index;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @Override
  public Optional<ItemId> getParent() {
    return Optional.ofNullable(parent);
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @Override
  public Integer getIndex() {
    return index;
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link ItemIndex#getParent() parent} attribute.
   * @param value The value for parent
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableItemIndex withParent(ItemId value) {
    ItemId newValue = Objects.requireNonNull(value, "parent");
    if (this.parent == newValue) return this;
    return new ImmutableItemIndex(this, newValue, this.index);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ItemIndex#getParent() parent} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for parent
   * @return A modified copy or {@code this} if not changed
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableItemIndex withParent(Optional<? extends ItemId> optional) {
    @Nullable ItemId value = optional.orElse(null);
    if (this.parent == value) return this;
    return new ImmutableItemIndex(this, value, this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemIndex#getIndex() index} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for index
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableItemIndex withIndex(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "index");
    if (this.index.equals(newValue)) return this;
    return new ImmutableItemIndex(this, this.parent, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemIndex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemIndex
        && equalsByValue((ImmutableItemIndex) another);
  }

  private boolean equalsByValue(ImmutableItemIndex another) {
    return Objects.equals(parent, another.parent)
        && index.equals(another.index);
  }

  /**
   * Computes a hash code from attributes: {@code parent}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(parent);
    h += (h << 5) + index.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemIndex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ItemIndex")
        .omitNullValues()
        .add("parent", parent)
        .add("index", index)
        .toString();
  }

  /**
   * Construct a new immutable {@code ItemIndex} instance.
   * @param index The value for the {@code index} attribute
   * @param parent The value for the {@code parent} attribute
   * @return An immutable ItemIndex instance
   */
  public static ImmutableItemIndex of(Integer index, Optional<? extends ItemId> parent) {
    return new ImmutableItemIndex(index, parent);
  }

  /**
   * Creates an immutable copy of a {@link ItemIndex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemIndex instance
   */
  public static ImmutableItemIndex copyOf(ItemIndex instance) {
    if (instance instanceof ImmutableItemIndex) {
      return (ImmutableItemIndex) instance;
    }
    return ImmutableItemIndex.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemIndex ImmutableItemIndex}.
   * <pre>
   * ImmutableItemIndex.builder()
   *    .parent(Optional&lt;io.dialob.session.engine.session.model.ItemId&gt;) // optional {@link ItemIndex#getParent() parent}
   *    .index(Integer) // required {@link ItemIndex#getIndex() index}
   *    .build();
   * </pre>
   * @return A new ImmutableItemIndex builder
   */
  public static ImmutableItemIndex.Builder builder() {
    return new ImmutableItemIndex.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemIndex ImmutableItemIndex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemIndex", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_INDEX = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId parent;
    private @Nullable Integer index;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.model.ItemIndex} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemIndex instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.model.ItemId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemId instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof ItemIndex) {
        ItemIndex instance = (ItemIndex) object;
        if ((bits & 0x1L) == 0) {
          Optional<ItemId> parentOptional = instance.getParent();
          if (parentOptional.isPresent()) {
            parent(parentOptional);
          }
          bits |= 0x1L;
        }
        this.index(instance.getIndex());
      }
      if (object instanceof ItemId) {
        ItemId instance = (ItemId) object;
        if ((bits & 0x1L) == 0) {
          Optional<ItemId> parentOptional = instance.getParent();
          if (parentOptional.isPresent()) {
            parent(parentOptional);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the optional value {@link ItemIndex#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(ItemId parent) {
      this.parent = Objects.requireNonNull(parent, "parent");
      return this;
    }

    /**
     * Initializes the optional value {@link ItemIndex#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(Optional<? extends ItemId> parent) {
      this.parent = parent.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ItemIndex#getIndex() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder index(Integer index) {
      this.index = Objects.requireNonNull(index, "index");
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemIndex ImmutableItemIndex}.
     * @return An immutable instance of ItemIndex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemIndex build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemIndex(null, parent, index);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      return "Cannot build ItemIndex, some of required attributes are not set " + attributes;
    }
  }
}
