package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueSetUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueSetUpdatedEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueSetUpdatedEvent.of()}.
 */
@Generated(from = "ValueSetUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValueSetUpdatedEvent
    implements ValueSetUpdatedEvent {
  private final ValueSetId valueSetId;

  private ImmutableValueSetUpdatedEvent(ValueSetId valueSetId) {
    this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
  }

  private ImmutableValueSetUpdatedEvent(
      ImmutableValueSetUpdatedEvent original,
      ValueSetId valueSetId) {
    this.valueSetId = valueSetId;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @Override
  public ValueSetId getValueSetId() {
    return valueSetId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSetUpdatedEvent#getValueSetId() valueSetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueSetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableValueSetUpdatedEvent withValueSetId(ValueSetId value) {
    if (this.valueSetId == value) return this;
    ValueSetId newValue = Objects.requireNonNull(value, "valueSetId");
    return new ImmutableValueSetUpdatedEvent(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueSetUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueSetUpdatedEvent
        && equalsByValue((ImmutableValueSetUpdatedEvent) another);
  }

  private boolean equalsByValue(ImmutableValueSetUpdatedEvent another) {
    return valueSetId.equals(another.valueSetId);
  }

  /**
   * Computes a hash code from attributes: {@code valueSetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueSetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueSetUpdatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueSetUpdatedEvent")
        .omitNullValues()
        .add("valueSetId", valueSetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code ValueSetUpdatedEvent} instance.
   * @param valueSetId The value for the {@code valueSetId} attribute
   * @return An immutable ValueSetUpdatedEvent instance
   */
  public static ImmutableValueSetUpdatedEvent of(ValueSetId valueSetId) {
    return new ImmutableValueSetUpdatedEvent(valueSetId);
  }

  /**
   * Creates an immutable copy of a {@link ValueSetUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueSetUpdatedEvent instance
   */
  public static ImmutableValueSetUpdatedEvent copyOf(ValueSetUpdatedEvent instance) {
    if (instance instanceof ImmutableValueSetUpdatedEvent) {
      return (ImmutableValueSetUpdatedEvent) instance;
    }
    return ImmutableValueSetUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueSetUpdatedEvent ImmutableValueSetUpdatedEvent}.
   * <pre>
   * ImmutableValueSetUpdatedEvent.builder()
   *    .valueSetId(io.dialob.session.engine.session.model.ValueSetId) // required {@link ValueSetUpdatedEvent#getValueSetId() valueSetId}
   *    .build();
   * </pre>
   * @return A new ImmutableValueSetUpdatedEvent builder
   */
  public static ImmutableValueSetUpdatedEvent.Builder builder() {
    return new ImmutableValueSetUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueSetUpdatedEvent ImmutableValueSetUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueSetUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE_SET_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ValueSetId valueSetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.ValueSetUpdatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueSetUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.ValueSetEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueSetEvent instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof ValueSetUpdatedEvent) {
        ValueSetUpdatedEvent instance = (ValueSetUpdatedEvent) object;
        if ((bits & 0x1L) == 0) {
          this.valueSetId(instance.getValueSetId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ValueSetEvent) {
        ValueSetEvent instance = (ValueSetEvent) object;
        if ((bits & 0x1L) == 0) {
          this.valueSetId(instance.getValueSetId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ValueSetUpdatedEvent#getValueSetId() valueSetId} attribute.
     * @param valueSetId The value for valueSetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(ValueSetId valueSetId) {
      this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
      initBits &= ~INIT_BIT_VALUE_SET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueSetUpdatedEvent ImmutableValueSetUpdatedEvent}.
     * @return An immutable instance of ValueSetUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueSetUpdatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueSetUpdatedEvent(null, valueSetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE_SET_ID) != 0) attributes.add("valueSetId");
      return "Cannot build ValueSetUpdatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
