package io.dialob.session.engine.session.command.event;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SessionLocaleUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSessionLocaleUpdatedEvent.builder()}.
 */
@Generated(from = "SessionLocaleUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSessionLocaleUpdatedEvent
    implements SessionLocaleUpdatedEvent {

  private ImmutableSessionLocaleUpdatedEvent(ImmutableSessionLocaleUpdatedEvent.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSessionLocaleUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSessionLocaleUpdatedEvent
        && equalsByValue((ImmutableSessionLocaleUpdatedEvent) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalsByValue(ImmutableSessionLocaleUpdatedEvent another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1682267922;
  }

  /**
   * Prints the immutable value {@code SessionLocaleUpdatedEvent}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SessionLocaleUpdatedEvent{}";
  }

  /**
   * Creates an immutable copy of a {@link SessionLocaleUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SessionLocaleUpdatedEvent instance
   */
  public static ImmutableSessionLocaleUpdatedEvent copyOf(SessionLocaleUpdatedEvent instance) {
    if (instance instanceof ImmutableSessionLocaleUpdatedEvent) {
      return (ImmutableSessionLocaleUpdatedEvent) instance;
    }
    return ImmutableSessionLocaleUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSessionLocaleUpdatedEvent ImmutableSessionLocaleUpdatedEvent}.
   * <pre>
   * ImmutableSessionLocaleUpdatedEvent.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableSessionLocaleUpdatedEvent builder
   */
  public static ImmutableSessionLocaleUpdatedEvent.Builder builder() {
    return new ImmutableSessionLocaleUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSessionLocaleUpdatedEvent ImmutableSessionLocaleUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SessionLocaleUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SessionLocaleUpdatedEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SessionLocaleUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSessionLocaleUpdatedEvent ImmutableSessionLocaleUpdatedEvent}.
     * @return An immutable instance of SessionLocaleUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSessionLocaleUpdatedEvent build() {
      return new ImmutableSessionLocaleUpdatedEvent(this);
    }
  }
}
