package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RowGroupItemsInitEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRowGroupItemsInitEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRowGroupItemsInitEvent.of()}.
 */
@Generated(from = "RowGroupItemsInitEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRowGroupItemsInitEvent
    implements RowGroupItemsInitEvent {
  private final TargetEvent target;
  private final ItemId groupId;
  private final ItemId prototypeId;

  private ImmutableRowGroupItemsInitEvent(
      ItemId groupId,
      ItemId prototypeId,
      TargetEvent target) {
    this.groupId = Objects.requireNonNull(groupId, "groupId");
    this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
    this.target = Objects.requireNonNull(target, "target");
  }

  private ImmutableRowGroupItemsInitEvent(
      ImmutableRowGroupItemsInitEvent original,
      TargetEvent target,
      ItemId groupId,
      ItemId prototypeId) {
    this.target = target;
    this.groupId = groupId;
    this.prototypeId = prototypeId;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public TargetEvent getTarget() {
    return target;
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @Override
  public ItemId getGroupId() {
    return groupId;
  }

  /**
   * @return The value of the {@code prototypeId} attribute
   */
  @Override
  public ItemId getPrototypeId() {
    return prototypeId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RowGroupItemsInitEvent#getTarget() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRowGroupItemsInitEvent withTarget(TargetEvent value) {
    if (this.target == value) return this;
    TargetEvent newValue = Objects.requireNonNull(value, "target");
    return new ImmutableRowGroupItemsInitEvent(this, newValue, this.groupId, this.prototypeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RowGroupItemsInitEvent#getGroupId() groupId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRowGroupItemsInitEvent withGroupId(ItemId value) {
    if (this.groupId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "groupId");
    return new ImmutableRowGroupItemsInitEvent(this, this.target, newValue, this.prototypeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RowGroupItemsInitEvent#getPrototypeId() prototypeId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for prototypeId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRowGroupItemsInitEvent withPrototypeId(ItemId value) {
    if (this.prototypeId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "prototypeId");
    return new ImmutableRowGroupItemsInitEvent(this, this.target, this.groupId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRowGroupItemsInitEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRowGroupItemsInitEvent
        && equalsByValue((ImmutableRowGroupItemsInitEvent) another);
  }

  private boolean equalsByValue(ImmutableRowGroupItemsInitEvent another) {
    return target.equals(another.target)
        && groupId.equals(another.groupId)
        && prototypeId.equals(another.prototypeId);
  }

  /**
   * Computes a hash code from attributes: {@code target}, {@code groupId}, {@code prototypeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + target.hashCode();
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + prototypeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RowGroupItemsInitEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RowGroupItemsInitEvent")
        .omitNullValues()
        .add("target", target)
        .add("groupId", groupId)
        .add("prototypeId", prototypeId)
        .toString();
  }

  /**
   * Construct a new immutable {@code RowGroupItemsInitEvent} instance.
   * @param groupId The value for the {@code groupId} attribute
   * @param prototypeId The value for the {@code prototypeId} attribute
   * @param target The value for the {@code target} attribute
   * @return An immutable RowGroupItemsInitEvent instance
   */
  public static ImmutableRowGroupItemsInitEvent of(ItemId groupId, ItemId prototypeId, TargetEvent target) {
    return new ImmutableRowGroupItemsInitEvent(groupId, prototypeId, target);
  }

  /**
   * Creates an immutable copy of a {@link RowGroupItemsInitEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RowGroupItemsInitEvent instance
   */
  public static ImmutableRowGroupItemsInitEvent copyOf(RowGroupItemsInitEvent instance) {
    if (instance instanceof ImmutableRowGroupItemsInitEvent) {
      return (ImmutableRowGroupItemsInitEvent) instance;
    }
    return ImmutableRowGroupItemsInitEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRowGroupItemsInitEvent ImmutableRowGroupItemsInitEvent}.
   * <pre>
   * ImmutableRowGroupItemsInitEvent.builder()
   *    .target(io.dialob.session.engine.session.command.event.TargetEvent) // required {@link RowGroupItemsInitEvent#getTarget() target}
   *    .groupId(io.dialob.session.engine.session.model.ItemId) // required {@link RowGroupItemsInitEvent#getGroupId() groupId}
   *    .prototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link RowGroupItemsInitEvent#getPrototypeId() prototypeId}
   *    .build();
   * </pre>
   * @return A new ImmutableRowGroupItemsInitEvent builder
   */
  public static ImmutableRowGroupItemsInitEvent.Builder builder() {
    return new ImmutableRowGroupItemsInitEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRowGroupItemsInitEvent ImmutableRowGroupItemsInitEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RowGroupItemsInitEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET = 0x1L;
    private static final long INIT_BIT_GROUP_ID = 0x2L;
    private static final long INIT_BIT_PROTOTYPE_ID = 0x4L;
    private long initBits = 0x7L;

    private @Nullable TargetEvent target;
    private @Nullable ItemId groupId;
    private @Nullable ItemId prototypeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.GroupEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GroupEvent instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.AttributeEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AttributeEvent instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.RowGroupItemsInitEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RowGroupItemsInitEvent instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof GroupEvent) {
        GroupEvent instance = (GroupEvent) object;
        if ((bits & 0x1L) == 0) {
          this.target(instance.getTarget());
          bits |= 0x1L;
        }
      }
      if (object instanceof AttributeEvent) {
        AttributeEvent instance = (AttributeEvent) object;
        if ((bits & 0x1L) == 0) {
          this.target(instance.getTarget());
          bits |= 0x1L;
        }
      }
      if (object instanceof RowGroupItemsInitEvent) {
        RowGroupItemsInitEvent instance = (RowGroupItemsInitEvent) object;
        this.groupId(instance.getGroupId());
        this.prototypeId(instance.getPrototypeId());
        if ((bits & 0x1L) == 0) {
          this.target(instance.getTarget());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link RowGroupItemsInitEvent#getTarget() target} attribute.
     * @param target The value for target 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(TargetEvent target) {
      this.target = Objects.requireNonNull(target, "target");
      initBits &= ~INIT_BIT_TARGET;
      return this;
    }

    /**
     * Initializes the value for the {@link RowGroupItemsInitEvent#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder groupId(ItemId groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RowGroupItemsInitEvent#getPrototypeId() prototypeId} attribute.
     * @param prototypeId The value for prototypeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder prototypeId(ItemId prototypeId) {
      this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
      initBits &= ~INIT_BIT_PROTOTYPE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRowGroupItemsInitEvent ImmutableRowGroupItemsInitEvent}.
     * @return An immutable instance of RowGroupItemsInitEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRowGroupItemsInitEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRowGroupItemsInitEvent(null, target, groupId, prototypeId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET) != 0) attributes.add("target");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_PROTOTYPE_ID) != 0) attributes.add("prototypeId");
      return "Cannot build RowGroupItemsInitEvent, some of required attributes are not set " + attributes;
    }
  }
}
