package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProtoTypeItemsAddedEventsProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProtoTypeItemsAddedEventsProvider.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableProtoTypeItemsAddedEventsProvider.of()}.
 */
@Generated(from = "ProtoTypeItemsAddedEventsProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProtoTypeItemsAddedEventsProvider
    implements ProtoTypeItemsAddedEventsProvider {
  private final ImmutableList<ItemId> itemPrototypeIds;

  private ImmutableProtoTypeItemsAddedEventsProvider(Iterable<? extends ItemId> itemPrototypeIds) {
    this.itemPrototypeIds = ImmutableList.copyOf(itemPrototypeIds);
  }

  private ImmutableProtoTypeItemsAddedEventsProvider(
      ImmutableProtoTypeItemsAddedEventsProvider original,
      ImmutableList<ItemId> itemPrototypeIds) {
    this.itemPrototypeIds = itemPrototypeIds;
  }

  /**
   * @return The value of the {@code itemPrototypeIds} attribute
   */
  @Override
  public ImmutableList<ItemId> getItemPrototypeIds() {
    return itemPrototypeIds;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProtoTypeItemsAddedEventsProvider#getItemPrototypeIds() itemPrototypeIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProtoTypeItemsAddedEventsProvider withItemPrototypeIds(ItemId... elements) {
    ImmutableList<ItemId> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProtoTypeItemsAddedEventsProvider(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProtoTypeItemsAddedEventsProvider#getItemPrototypeIds() itemPrototypeIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of itemPrototypeIds elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableProtoTypeItemsAddedEventsProvider withItemPrototypeIds(Iterable<? extends ItemId> elements) {
    if (this.itemPrototypeIds == elements) return this;
    ImmutableList<ItemId> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProtoTypeItemsAddedEventsProvider(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProtoTypeItemsAddedEventsProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProtoTypeItemsAddedEventsProvider
        && equalsByValue((ImmutableProtoTypeItemsAddedEventsProvider) another);
  }

  private boolean equalsByValue(ImmutableProtoTypeItemsAddedEventsProvider another) {
    return itemPrototypeIds.equals(another.itemPrototypeIds);
  }

  /**
   * Computes a hash code from attributes: {@code itemPrototypeIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + itemPrototypeIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProtoTypeItemsAddedEventsProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProtoTypeItemsAddedEventsProvider")
        .omitNullValues()
        .add("itemPrototypeIds", itemPrototypeIds)
        .toString();
  }

  /**
   * Construct a new immutable {@code ProtoTypeItemsAddedEventsProvider} instance.
   * @param itemPrototypeIds The value for the {@code itemPrototypeIds} attribute
   * @return An immutable ProtoTypeItemsAddedEventsProvider instance
   */
  public static ImmutableProtoTypeItemsAddedEventsProvider of(List<ItemId> itemPrototypeIds) {
    return of((Iterable<? extends ItemId>) itemPrototypeIds);
  }

  /**
   * Construct a new immutable {@code ProtoTypeItemsAddedEventsProvider} instance.
   * @param itemPrototypeIds The value for the {@code itemPrototypeIds} attribute
   * @return An immutable ProtoTypeItemsAddedEventsProvider instance
   */
  public static ImmutableProtoTypeItemsAddedEventsProvider of(Iterable<? extends ItemId> itemPrototypeIds) {
    return new ImmutableProtoTypeItemsAddedEventsProvider(itemPrototypeIds);
  }

  /**
   * Creates an immutable copy of a {@link ProtoTypeItemsAddedEventsProvider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProtoTypeItemsAddedEventsProvider instance
   */
  public static ImmutableProtoTypeItemsAddedEventsProvider copyOf(ProtoTypeItemsAddedEventsProvider instance) {
    if (instance instanceof ImmutableProtoTypeItemsAddedEventsProvider) {
      return (ImmutableProtoTypeItemsAddedEventsProvider) instance;
    }
    return ImmutableProtoTypeItemsAddedEventsProvider.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProtoTypeItemsAddedEventsProvider ImmutableProtoTypeItemsAddedEventsProvider}.
   * <pre>
   * ImmutableProtoTypeItemsAddedEventsProvider.builder()
   *    .addItemPrototypeIds|addAllItemPrototypeIds(io.dialob.session.engine.session.model.ItemId) // {@link ProtoTypeItemsAddedEventsProvider#getItemPrototypeIds() itemPrototypeIds} elements
   *    .build();
   * </pre>
   * @return A new ImmutableProtoTypeItemsAddedEventsProvider builder
   */
  public static ImmutableProtoTypeItemsAddedEventsProvider.Builder builder() {
    return new ImmutableProtoTypeItemsAddedEventsProvider.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProtoTypeItemsAddedEventsProvider ImmutableProtoTypeItemsAddedEventsProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProtoTypeItemsAddedEventsProvider", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<ItemId> itemPrototypeIds = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProtoTypeItemsAddedEventsProvider} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ProtoTypeItemsAddedEventsProvider instance) {
      Objects.requireNonNull(instance, "instance");
      addAllItemPrototypeIds(instance.getItemPrototypeIds());
      return this;
    }

    /**
     * Adds one element to {@link ProtoTypeItemsAddedEventsProvider#getItemPrototypeIds() itemPrototypeIds} list.
     * @param element A itemPrototypeIds element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItemPrototypeIds(ItemId element) {
      this.itemPrototypeIds.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProtoTypeItemsAddedEventsProvider#getItemPrototypeIds() itemPrototypeIds} list.
     * @param elements An array of itemPrototypeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItemPrototypeIds(ItemId... elements) {
      this.itemPrototypeIds.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProtoTypeItemsAddedEventsProvider#getItemPrototypeIds() itemPrototypeIds} list.
     * @param elements An iterable of itemPrototypeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemPrototypeIds(Iterable<? extends ItemId> elements) {
      this.itemPrototypeIds = ImmutableList.builder();
      return addAllItemPrototypeIds(elements);
    }

    /**
     * Adds elements to {@link ProtoTypeItemsAddedEventsProvider#getItemPrototypeIds() itemPrototypeIds} list.
     * @param elements An iterable of itemPrototypeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllItemPrototypeIds(Iterable<? extends ItemId> elements) {
      this.itemPrototypeIds.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableProtoTypeItemsAddedEventsProvider ImmutableProtoTypeItemsAddedEventsProvider}.
     * @return An immutable instance of ProtoTypeItemsAddedEventsProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProtoTypeItemsAddedEventsProvider build() {
      return new ImmutableProtoTypeItemsAddedEventsProvider(null, itemPrototypeIds.build());
    }
  }
}
