package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ErrorId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErrorActiveUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErrorActiveUpdatedEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableErrorActiveUpdatedEvent.of()}.
 */
@Generated(from = "ErrorActiveUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableErrorActiveUpdatedEvent
    implements ErrorActiveUpdatedEvent {
  private final ErrorId errorId;

  private ImmutableErrorActiveUpdatedEvent(ErrorId errorId) {
    this.errorId = Objects.requireNonNull(errorId, "errorId");
  }

  private ImmutableErrorActiveUpdatedEvent(ImmutableErrorActiveUpdatedEvent original, ErrorId errorId) {
    this.errorId = errorId;
  }

  /**
   * @return The value of the {@code errorId} attribute
   */
  @Override
  public ErrorId getErrorId() {
    return errorId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorActiveUpdatedEvent#getErrorId() errorId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableErrorActiveUpdatedEvent withErrorId(ErrorId value) {
    if (this.errorId == value) return this;
    ErrorId newValue = Objects.requireNonNull(value, "errorId");
    return new ImmutableErrorActiveUpdatedEvent(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErrorActiveUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErrorActiveUpdatedEvent
        && equalsByValue((ImmutableErrorActiveUpdatedEvent) another);
  }

  private boolean equalsByValue(ImmutableErrorActiveUpdatedEvent another) {
    return errorId.equals(another.errorId);
  }

  /**
   * Computes a hash code from attributes: {@code errorId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + errorId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ErrorActiveUpdatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorActiveUpdatedEvent")
        .omitNullValues()
        .add("errorId", errorId)
        .toString();
  }

  /**
   * Construct a new immutable {@code ErrorActiveUpdatedEvent} instance.
   * @param errorId The value for the {@code errorId} attribute
   * @return An immutable ErrorActiveUpdatedEvent instance
   */
  public static ImmutableErrorActiveUpdatedEvent of(ErrorId errorId) {
    return new ImmutableErrorActiveUpdatedEvent(errorId);
  }

  /**
   * Creates an immutable copy of a {@link ErrorActiveUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ErrorActiveUpdatedEvent instance
   */
  public static ImmutableErrorActiveUpdatedEvent copyOf(ErrorActiveUpdatedEvent instance) {
    if (instance instanceof ImmutableErrorActiveUpdatedEvent) {
      return (ImmutableErrorActiveUpdatedEvent) instance;
    }
    return ImmutableErrorActiveUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErrorActiveUpdatedEvent ImmutableErrorActiveUpdatedEvent}.
   * <pre>
   * ImmutableErrorActiveUpdatedEvent.builder()
   *    .errorId(io.dialob.session.engine.session.model.ErrorId) // required {@link ErrorActiveUpdatedEvent#getErrorId() errorId}
   *    .build();
   * </pre>
   * @return A new ImmutableErrorActiveUpdatedEvent builder
   */
  public static ImmutableErrorActiveUpdatedEvent.Builder builder() {
    return new ImmutableErrorActiveUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErrorActiveUpdatedEvent ImmutableErrorActiveUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErrorActiveUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ERROR_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ErrorId errorId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.ErrorActiveUpdatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ErrorActiveUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.ErrorEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ErrorEvent instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof ErrorActiveUpdatedEvent) {
        ErrorActiveUpdatedEvent instance = (ErrorActiveUpdatedEvent) object;
        if ((bits & 0x1L) == 0) {
          this.errorId(instance.getErrorId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ErrorEvent) {
        ErrorEvent instance = (ErrorEvent) object;
        if ((bits & 0x1L) == 0) {
          this.errorId(instance.getErrorId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ErrorActiveUpdatedEvent#getErrorId() errorId} attribute.
     * @param errorId The value for errorId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errorId(ErrorId errorId) {
      this.errorId = Objects.requireNonNull(errorId, "errorId");
      initBits &= ~INIT_BIT_ERROR_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableErrorActiveUpdatedEvent ImmutableErrorActiveUpdatedEvent}.
     * @return An immutable instance of ErrorActiveUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErrorActiveUpdatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableErrorActiveUpdatedEvent(null, errorId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ERROR_ID) != 0) attributes.add("errorId");
      return "Cannot build ErrorActiveUpdatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
