package io.dialob.session.engine.session.command.event;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AvailableItemsUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAvailableItemsUpdatedEvent.builder()}.
 */
@Generated(from = "AvailableItemsUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAvailableItemsUpdatedEvent
    implements AvailableItemsUpdatedEvent {

  private ImmutableAvailableItemsUpdatedEvent(ImmutableAvailableItemsUpdatedEvent.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAvailableItemsUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAvailableItemsUpdatedEvent
        && equalsByValue((ImmutableAvailableItemsUpdatedEvent) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalsByValue(ImmutableAvailableItemsUpdatedEvent another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1868228267;
  }

  /**
   * Prints the immutable value {@code AvailableItemsUpdatedEvent}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AvailableItemsUpdatedEvent{}";
  }

  /**
   * Creates an immutable copy of a {@link AvailableItemsUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AvailableItemsUpdatedEvent instance
   */
  public static ImmutableAvailableItemsUpdatedEvent copyOf(AvailableItemsUpdatedEvent instance) {
    if (instance instanceof ImmutableAvailableItemsUpdatedEvent) {
      return (ImmutableAvailableItemsUpdatedEvent) instance;
    }
    return ImmutableAvailableItemsUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAvailableItemsUpdatedEvent ImmutableAvailableItemsUpdatedEvent}.
   * <pre>
   * ImmutableAvailableItemsUpdatedEvent.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableAvailableItemsUpdatedEvent builder
   */
  public static ImmutableAvailableItemsUpdatedEvent.Builder builder() {
    return new ImmutableAvailableItemsUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAvailableItemsUpdatedEvent ImmutableAvailableItemsUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AvailableItemsUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AvailableItemsUpdatedEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AvailableItemsUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableAvailableItemsUpdatedEvent ImmutableAvailableItemsUpdatedEvent}.
     * @return An immutable instance of AvailableItemsUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAvailableItemsUpdatedEvent build() {
      return new ImmutableAvailableItemsUpdatedEvent(this);
    }
  }
}
