package io.dialob.session.engine.session.command.event;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AnyInvalidAnswersUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnyInvalidAnswersUpdatedEvent.builder()}.
 */
@Generated(from = "AnyInvalidAnswersUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAnyInvalidAnswersUpdatedEvent
    implements AnyInvalidAnswersUpdatedEvent {

  private ImmutableAnyInvalidAnswersUpdatedEvent(ImmutableAnyInvalidAnswersUpdatedEvent.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnyInvalidAnswersUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnyInvalidAnswersUpdatedEvent
        && equalsByValue((ImmutableAnyInvalidAnswersUpdatedEvent) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalsByValue(ImmutableAnyInvalidAnswersUpdatedEvent another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 84576488;
  }

  /**
   * Prints the immutable value {@code AnyInvalidAnswersUpdatedEvent}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AnyInvalidAnswersUpdatedEvent{}";
  }

  /**
   * Creates an immutable copy of a {@link AnyInvalidAnswersUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AnyInvalidAnswersUpdatedEvent instance
   */
  public static ImmutableAnyInvalidAnswersUpdatedEvent copyOf(AnyInvalidAnswersUpdatedEvent instance) {
    if (instance instanceof ImmutableAnyInvalidAnswersUpdatedEvent) {
      return (ImmutableAnyInvalidAnswersUpdatedEvent) instance;
    }
    return ImmutableAnyInvalidAnswersUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnyInvalidAnswersUpdatedEvent ImmutableAnyInvalidAnswersUpdatedEvent}.
   * <pre>
   * ImmutableAnyInvalidAnswersUpdatedEvent.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableAnyInvalidAnswersUpdatedEvent builder
   */
  public static ImmutableAnyInvalidAnswersUpdatedEvent.Builder builder() {
    return new ImmutableAnyInvalidAnswersUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnyInvalidAnswersUpdatedEvent ImmutableAnyInvalidAnswersUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AnyInvalidAnswersUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AnyInvalidAnswersUpdatedEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AnyInvalidAnswersUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnyInvalidAnswersUpdatedEvent ImmutableAnyInvalidAnswersUpdatedEvent}.
     * @return An immutable instance of AnyInvalidAnswersUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnyInvalidAnswersUpdatedEvent build() {
      return new ImmutableAnyInvalidAnswersUpdatedEvent(this);
    }
  }
}
