package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateRowsCanBeAddedCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateRowsCanBeAddedCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableUpdateRowsCanBeAddedCommand.of()}.
 */
@Generated(from = "UpdateRowsCanBeAddedCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdateRowsCanBeAddedCommand
    implements UpdateRowsCanBeAddedCommand {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final Expression expression;

  private ImmutableUpdateRowsCanBeAddedCommand(
      ItemId targetId,
      Expression expression,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.expression = Objects.requireNonNull(expression, "expression");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableUpdateRowsCanBeAddedCommand(
      ImmutableUpdateRowsCanBeAddedCommand original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      Expression expression) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.expression = expression;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateRowsCanBeAddedCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableUpdateRowsCanBeAddedCommand withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateRowsCanBeAddedCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateRowsCanBeAddedCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableUpdateRowsCanBeAddedCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateRowsCanBeAddedCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateRowsCanBeAddedCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableUpdateRowsCanBeAddedCommand withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableUpdateRowsCanBeAddedCommand(this, this.triggers, newValue, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateRowsCanBeAddedCommand#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableUpdateRowsCanBeAddedCommand withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableUpdateRowsCanBeAddedCommand(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateRowsCanBeAddedCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateRowsCanBeAddedCommand
        && equalsByValue((ImmutableUpdateRowsCanBeAddedCommand) another);
  }

  private boolean equalsByValue(ImmutableUpdateRowsCanBeAddedCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateRowsCanBeAddedCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UpdateRowsCanBeAddedCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code UpdateRowsCanBeAddedCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateRowsCanBeAddedCommand instance
   */
  public static ImmutableUpdateRowsCanBeAddedCommand of(ItemId targetId, Expression expression, List<Trigger<ItemState>> triggers) {
    return of(targetId, expression, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code UpdateRowsCanBeAddedCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateRowsCanBeAddedCommand instance
   */
  public static ImmutableUpdateRowsCanBeAddedCommand of(ItemId targetId, Expression expression, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableUpdateRowsCanBeAddedCommand(targetId, expression, triggers);
  }

  /**
   * Creates an immutable copy of a {@link UpdateRowsCanBeAddedCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateRowsCanBeAddedCommand instance
   */
  public static ImmutableUpdateRowsCanBeAddedCommand copyOf(UpdateRowsCanBeAddedCommand instance) {
    if (instance instanceof ImmutableUpdateRowsCanBeAddedCommand) {
      return (ImmutableUpdateRowsCanBeAddedCommand) instance;
    }
    return ImmutableUpdateRowsCanBeAddedCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateRowsCanBeAddedCommand ImmutableUpdateRowsCanBeAddedCommand}.
   * <pre>
   * ImmutableUpdateRowsCanBeAddedCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&lt;io.dialob.session.engine.session.model.ItemState&gt;) // {@link UpdateRowsCanBeAddedCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link UpdateRowsCanBeAddedCommand#getTargetId() targetId}
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link UpdateRowsCanBeAddedCommand#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateRowsCanBeAddedCommand builder
   */
  public static ImmutableUpdateRowsCanBeAddedCommand.Builder builder() {
    return new ImmutableUpdateRowsCanBeAddedCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateRowsCanBeAddedCommand ImmutableUpdateRowsCanBeAddedCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateRowsCanBeAddedCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private static final long INIT_BIT_EXPRESSION = 0x2L;
    private long initBits = 0x3L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.AbstractUpdateBooleanAttributeCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractUpdateBooleanAttributeCommand instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.UpdateRowsCanBeAddedCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateRowsCanBeAddedCommand instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof AbstractUpdateBooleanAttributeCommand) {
        AbstractUpdateBooleanAttributeCommand instance = (AbstractUpdateBooleanAttributeCommand) object;
        if ((bits & 0x1L) == 0) {
          this.expression(instance.getExpression());
          bits |= 0x1L;
        }
      }
      if (object instanceof UpdateRowsCanBeAddedCommand) {
        UpdateRowsCanBeAddedCommand instance = (UpdateRowsCanBeAddedCommand) object;
        this.targetId(instance.getTargetId());
        addAllTriggers(instance.getTriggers());
        if ((bits & 0x1L) == 0) {
          this.expression(instance.getExpression());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link UpdateRowsCanBeAddedCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateRowsCanBeAddedCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateRowsCanBeAddedCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link UpdateRowsCanBeAddedCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRowsCanBeAddedCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRowsCanBeAddedCommand#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateRowsCanBeAddedCommand ImmutableUpdateRowsCanBeAddedCommand}.
     * @return An immutable instance of UpdateRowsCanBeAddedCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateRowsCanBeAddedCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdateRowsCanBeAddedCommand(null, triggers.build(), targetId, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build UpdateRowsCanBeAddedCommand, some of required attributes are not set " + attributes;
    }
  }
}
