package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateDescriptionCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateDescriptionCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableUpdateDescriptionCommand.of()}.
 */
@Generated(from = "UpdateDescriptionCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdateDescriptionCommand
    implements UpdateDescriptionCommand {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final Expression expression;

  private ImmutableUpdateDescriptionCommand(
      ItemId targetId,
      Expression expression,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.expression = Objects.requireNonNull(expression, "expression");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableUpdateDescriptionCommand(
      ImmutableUpdateDescriptionCommand original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      Expression expression) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.expression = expression;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateDescriptionCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableUpdateDescriptionCommand withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateDescriptionCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateDescriptionCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableUpdateDescriptionCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateDescriptionCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateDescriptionCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableUpdateDescriptionCommand withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableUpdateDescriptionCommand(this, this.triggers, newValue, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateDescriptionCommand#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableUpdateDescriptionCommand withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableUpdateDescriptionCommand(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateDescriptionCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateDescriptionCommand
        && equalsByValue((ImmutableUpdateDescriptionCommand) another);
  }

  private boolean equalsByValue(ImmutableUpdateDescriptionCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateDescriptionCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UpdateDescriptionCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code UpdateDescriptionCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateDescriptionCommand instance
   */
  public static ImmutableUpdateDescriptionCommand of(ItemId targetId, Expression expression, List<Trigger<ItemState>> triggers) {
    return of(targetId, expression, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code UpdateDescriptionCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateDescriptionCommand instance
   */
  public static ImmutableUpdateDescriptionCommand of(ItemId targetId, Expression expression, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableUpdateDescriptionCommand(targetId, expression, triggers);
  }

  /**
   * Creates an immutable copy of a {@link UpdateDescriptionCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateDescriptionCommand instance
   */
  public static ImmutableUpdateDescriptionCommand copyOf(UpdateDescriptionCommand instance) {
    if (instance instanceof ImmutableUpdateDescriptionCommand) {
      return (ImmutableUpdateDescriptionCommand) instance;
    }
    return ImmutableUpdateDescriptionCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateDescriptionCommand ImmutableUpdateDescriptionCommand}.
   * <pre>
   * ImmutableUpdateDescriptionCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&lt;io.dialob.session.engine.session.model.ItemState&gt;) // {@link UpdateDescriptionCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link UpdateDescriptionCommand#getTargetId() targetId}
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link UpdateDescriptionCommand#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateDescriptionCommand builder
   */
  public static ImmutableUpdateDescriptionCommand.Builder builder() {
    return new ImmutableUpdateDescriptionCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateDescriptionCommand ImmutableUpdateDescriptionCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateDescriptionCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private static final long INIT_BIT_EXPRESSION = 0x2L;
    private long initBits = 0x3L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateDescriptionCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateDescriptionCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      this.targetId(instance.getTargetId());
      this.expression(instance.getExpression());
      return this;
    }

    /**
     * Adds one element to {@link UpdateDescriptionCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateDescriptionCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateDescriptionCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link UpdateDescriptionCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateDescriptionCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateDescriptionCommand#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateDescriptionCommand ImmutableUpdateDescriptionCommand}.
     * @return An immutable instance of UpdateDescriptionCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateDescriptionCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdateDescriptionCommand(null, triggers.build(), targetId, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build UpdateDescriptionCommand, some of required attributes are not set " + attributes;
    }
  }
}
