package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SetAnswer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSetAnswer.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSetAnswer.of()}.
 */
@Generated(from = "SetAnswer", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSetAnswer implements SetAnswer {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final @Nullable Object answer;

  private ImmutableSetAnswer(
      ItemId targetId,
      @Nullable Object answer,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.answer = answer;
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableSetAnswer(
      ImmutableSetAnswer original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      @Nullable Object answer) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.answer = answer;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code answer} attribute
   */
  @Override
  public @Nullable Object getAnswer() {
    return answer;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetAnswer#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableSetAnswer withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetAnswer(this, newValue, this.targetId, this.answer);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetAnswer#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableSetAnswer withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetAnswer(this, newValue, this.targetId, this.answer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SetAnswer#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSetAnswer withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableSetAnswer(this, this.triggers, newValue, this.answer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SetAnswer#getAnswer() answer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for answer (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSetAnswer withAnswer(@Nullable Object value) {
    if (this.answer == value) return this;
    return new ImmutableSetAnswer(this, this.triggers, this.targetId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSetAnswer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSetAnswer
        && equalsByValue((ImmutableSetAnswer) another);
  }

  private boolean equalsByValue(ImmutableSetAnswer another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && Objects.equals(answer, another.answer);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code answer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + Objects.hashCode(answer);
    return h;
  }

  /**
   * Prints the immutable value {@code SetAnswer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SetAnswer")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("answer", answer)
        .toString();
  }

  /**
   * Construct a new immutable {@code SetAnswer} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param answer The value for the {@code answer} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetAnswer instance
   */
  public static ImmutableSetAnswer of(ItemId targetId, @Nullable Object answer, List<Trigger<ItemState>> triggers) {
    return of(targetId, answer, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code SetAnswer} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param answer The value for the {@code answer} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetAnswer instance
   */
  public static ImmutableSetAnswer of(ItemId targetId, @Nullable Object answer, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableSetAnswer(targetId, answer, triggers);
  }

  /**
   * Creates an immutable copy of a {@link SetAnswer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SetAnswer instance
   */
  public static ImmutableSetAnswer copyOf(SetAnswer instance) {
    if (instance instanceof ImmutableSetAnswer) {
      return (ImmutableSetAnswer) instance;
    }
    return ImmutableSetAnswer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSetAnswer ImmutableSetAnswer}.
   * <pre>
   * ImmutableSetAnswer.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&lt;io.dialob.session.engine.session.model.ItemState&gt;) // {@link SetAnswer#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link SetAnswer#getTargetId() targetId}
   *    .answer(Object | null) // nullable {@link SetAnswer#getAnswer() answer}
   *    .build();
   * </pre>
   * @return A new ImmutableSetAnswer builder
   */
  public static ImmutableSetAnswer.Builder builder() {
    return new ImmutableSetAnswer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSetAnswer ImmutableSetAnswer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SetAnswer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @javax.annotation.Nullable ItemId targetId;
    private @javax.annotation.Nullable Object answer;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetAnswer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SetAnswer instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      this.targetId(instance.getTargetId());
      @Nullable Object answerValue = instance.getAnswer();
      if (answerValue != null) {
        answer(answerValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link SetAnswer#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SetAnswer#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SetAnswer#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link SetAnswer#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link SetAnswer#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SetAnswer#getAnswer() answer} attribute.
     * @param answer The value for answer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder answer(@Nullable Object answer) {
      this.answer = answer;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSetAnswer ImmutableSetAnswer}.
     * @return An immutable instance of SetAnswer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSetAnswer build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSetAnswer(null, triggers.build(), targetId, answer);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      return "Cannot build SetAnswer, some of required attributes are not set " + attributes;
    }
  }
}
