package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NopCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNopCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNopCommand.of()}.
 */
@Generated(from = "NopCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNopCommand implements NopCommand {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;

  private ImmutableNopCommand(
      ItemId targetId,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableNopCommand(
      ImmutableNopCommand original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId) {
    this.triggers = triggers;
    this.targetId = targetId;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NopCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableNopCommand withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNopCommand(this, newValue, this.targetId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NopCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableNopCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNopCommand(this, newValue, this.targetId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NopCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableNopCommand withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableNopCommand(this, this.triggers, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNopCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNopCommand
        && equalsByValue((ImmutableNopCommand) another);
  }

  private boolean equalsByValue(ImmutableNopCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NopCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NopCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code NopCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable NopCommand instance
   */
  public static ImmutableNopCommand of(ItemId targetId, List<Trigger<ItemState>> triggers) {
    return of(targetId, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code NopCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable NopCommand instance
   */
  public static ImmutableNopCommand of(ItemId targetId, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableNopCommand(targetId, triggers);
  }

  /**
   * Creates an immutable copy of a {@link NopCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NopCommand instance
   */
  public static ImmutableNopCommand copyOf(NopCommand instance) {
    if (instance instanceof ImmutableNopCommand) {
      return (ImmutableNopCommand) instance;
    }
    return ImmutableNopCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNopCommand ImmutableNopCommand}.
   * <pre>
   * ImmutableNopCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&lt;io.dialob.session.engine.session.model.ItemState&gt;) // {@link NopCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link NopCommand#getTargetId() targetId}
   *    .build();
   * </pre>
   * @return A new ImmutableNopCommand builder
   */
  public static ImmutableNopCommand.Builder builder() {
    return new ImmutableNopCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNopCommand ImmutableNopCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NopCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NopCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NopCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      this.targetId(instance.getTargetId());
      return this;
    }

    /**
     * Adds one element to {@link NopCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NopCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NopCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link NopCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link NopCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNopCommand ImmutableNopCommand}.
     * @return An immutable instance of NopCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNopCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNopCommand(null, triggers.build(), targetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      return "Cannot build NopCommand, some of required attributes are not set " + attributes;
    }
  }
}
