package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeleteRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeleteRow.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDeleteRow.of()}.
 */
@Generated(from = "DeleteRow", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeleteRow implements DeleteRow {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final ItemId toBeRemoved;

  private ImmutableDeleteRow(
      ItemId targetId,
      ItemId toBeRemoved,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.toBeRemoved = Objects.requireNonNull(toBeRemoved, "toBeRemoved");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableDeleteRow(
      ImmutableDeleteRow original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      ItemId toBeRemoved) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.toBeRemoved = toBeRemoved;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code toBeRemoved} attribute
   */
  @Override
  public ItemId getToBeRemoved() {
    return toBeRemoved;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeleteRow#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableDeleteRow withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDeleteRow(this, newValue, this.targetId, this.toBeRemoved);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeleteRow#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableDeleteRow withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDeleteRow(this, newValue, this.targetId, this.toBeRemoved);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteRow#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableDeleteRow withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableDeleteRow(this, this.triggers, newValue, this.toBeRemoved);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteRow#getToBeRemoved() toBeRemoved} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toBeRemoved
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableDeleteRow withToBeRemoved(ItemId value) {
    if (this.toBeRemoved == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "toBeRemoved");
    return new ImmutableDeleteRow(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeleteRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeleteRow
        && equalsByValue((ImmutableDeleteRow) another);
  }

  private boolean equalsByValue(ImmutableDeleteRow another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && toBeRemoved.equals(another.toBeRemoved);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code toBeRemoved}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + toBeRemoved.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeleteRow")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("toBeRemoved", toBeRemoved)
        .toString();
  }

  /**
   * Construct a new immutable {@code DeleteRow} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param toBeRemoved The value for the {@code toBeRemoved} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable DeleteRow instance
   */
  public static ImmutableDeleteRow of(ItemId targetId, ItemId toBeRemoved, List<Trigger<ItemState>> triggers) {
    return of(targetId, toBeRemoved, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code DeleteRow} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param toBeRemoved The value for the {@code toBeRemoved} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable DeleteRow instance
   */
  public static ImmutableDeleteRow of(ItemId targetId, ItemId toBeRemoved, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableDeleteRow(targetId, toBeRemoved, triggers);
  }

  /**
   * Creates an immutable copy of a {@link DeleteRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeleteRow instance
   */
  public static ImmutableDeleteRow copyOf(DeleteRow instance) {
    if (instance instanceof ImmutableDeleteRow) {
      return (ImmutableDeleteRow) instance;
    }
    return ImmutableDeleteRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeleteRow ImmutableDeleteRow}.
   * <pre>
   * ImmutableDeleteRow.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&lt;io.dialob.session.engine.session.model.ItemState&gt;) // {@link DeleteRow#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link DeleteRow#getTargetId() targetId}
   *    .toBeRemoved(io.dialob.session.engine.session.model.ItemId) // required {@link DeleteRow#getToBeRemoved() toBeRemoved}
   *    .build();
   * </pre>
   * @return A new ImmutableDeleteRow builder
   */
  public static ImmutableDeleteRow.Builder builder() {
    return new ImmutableDeleteRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeleteRow ImmutableDeleteRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeleteRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private static final long INIT_BIT_TO_BE_REMOVED = 0x2L;
    private long initBits = 0x3L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private @Nullable ItemId toBeRemoved;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeleteRow instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      this.targetId(instance.getTargetId());
      this.toBeRemoved(instance.getToBeRemoved());
      return this;
    }

    /**
     * Adds one element to {@link DeleteRow#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DeleteRow#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DeleteRow#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link DeleteRow#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRow#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRow#getToBeRemoved() toBeRemoved} attribute.
     * @param toBeRemoved The value for toBeRemoved 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBeRemoved(ItemId toBeRemoved) {
      this.toBeRemoved = Objects.requireNonNull(toBeRemoved, "toBeRemoved");
      initBits &= ~INIT_BIT_TO_BE_REMOVED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeleteRow ImmutableDeleteRow}.
     * @return An immutable instance of DeleteRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeleteRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDeleteRow(null, triggers.build(), targetId, toBeRemoved);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      if ((initBits & INIT_BIT_TO_BE_REMOVED) != 0) attributes.add("toBeRemoved");
      return "Cannot build DeleteRow, some of required attributes are not set " + attributes;
    }
  }
}
