package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateRowGroupFromPrototypeCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateRowGroupFromPrototypeCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCreateRowGroupFromPrototypeCommand.of()}.
 */
@Generated(from = "CreateRowGroupFromPrototypeCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateRowGroupFromPrototypeCommand
    implements CreateRowGroupFromPrototypeCommand {
  private final ImmutableList<Trigger<ItemStates>> triggers;
  private final ItemId itemPrototypeId;

  private ImmutableCreateRowGroupFromPrototypeCommand(
      ItemId itemPrototypeId,
      Iterable<? extends Trigger<ItemStates>> triggers) {
    this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableCreateRowGroupFromPrototypeCommand(
      ImmutableCreateRowGroupFromPrototypeCommand original,
      ImmutableList<Trigger<ItemStates>> triggers,
      ItemId itemPrototypeId) {
    this.triggers = triggers;
    this.itemPrototypeId = itemPrototypeId;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemStates>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code itemPrototypeId} attribute
   */
  @Override
  public ItemId getItemPrototypeId() {
    return itemPrototypeId;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateRowGroupFromPrototypeCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableCreateRowGroupFromPrototypeCommand withTriggers(Trigger<ItemStates>... elements) {
    ImmutableList<Trigger<ItemStates>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateRowGroupFromPrototypeCommand(this, newValue, this.itemPrototypeId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateRowGroupFromPrototypeCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableCreateRowGroupFromPrototypeCommand withTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemStates>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateRowGroupFromPrototypeCommand(this, newValue, this.itemPrototypeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateRowGroupFromPrototypeCommand#getItemPrototypeId() itemPrototypeId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemPrototypeId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableCreateRowGroupFromPrototypeCommand withItemPrototypeId(ItemId value) {
    if (this.itemPrototypeId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemPrototypeId");
    return new ImmutableCreateRowGroupFromPrototypeCommand(this, this.triggers, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateRowGroupFromPrototypeCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateRowGroupFromPrototypeCommand
        && equalsByValue((ImmutableCreateRowGroupFromPrototypeCommand) another);
  }

  private boolean equalsByValue(ImmutableCreateRowGroupFromPrototypeCommand another) {
    return triggers.equals(another.triggers)
        && itemPrototypeId.equals(another.itemPrototypeId);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code itemPrototypeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + itemPrototypeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRowGroupFromPrototypeCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateRowGroupFromPrototypeCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("itemPrototypeId", itemPrototypeId)
        .toString();
  }

  /**
   * Construct a new immutable {@code CreateRowGroupFromPrototypeCommand} instance.
   * @param itemPrototypeId The value for the {@code itemPrototypeId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable CreateRowGroupFromPrototypeCommand instance
   */
  public static ImmutableCreateRowGroupFromPrototypeCommand of(ItemId itemPrototypeId, List<Trigger<ItemStates>> triggers) {
    return of(itemPrototypeId, (Iterable<? extends Trigger<ItemStates>>) triggers);
  }

  /**
   * Construct a new immutable {@code CreateRowGroupFromPrototypeCommand} instance.
   * @param itemPrototypeId The value for the {@code itemPrototypeId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable CreateRowGroupFromPrototypeCommand instance
   */
  public static ImmutableCreateRowGroupFromPrototypeCommand of(ItemId itemPrototypeId, Iterable<? extends Trigger<ItemStates>> triggers) {
    return new ImmutableCreateRowGroupFromPrototypeCommand(itemPrototypeId, triggers);
  }

  /**
   * Creates an immutable copy of a {@link CreateRowGroupFromPrototypeCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateRowGroupFromPrototypeCommand instance
   */
  public static ImmutableCreateRowGroupFromPrototypeCommand copyOf(CreateRowGroupFromPrototypeCommand instance) {
    if (instance instanceof ImmutableCreateRowGroupFromPrototypeCommand) {
      return (ImmutableCreateRowGroupFromPrototypeCommand) instance;
    }
    return ImmutableCreateRowGroupFromPrototypeCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateRowGroupFromPrototypeCommand ImmutableCreateRowGroupFromPrototypeCommand}.
   * <pre>
   * ImmutableCreateRowGroupFromPrototypeCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&lt;io.dialob.session.engine.session.model.ItemStates&gt;) // {@link CreateRowGroupFromPrototypeCommand#getTriggers() triggers} elements
   *    .itemPrototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link CreateRowGroupFromPrototypeCommand#getItemPrototypeId() itemPrototypeId}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateRowGroupFromPrototypeCommand builder
   */
  public static ImmutableCreateRowGroupFromPrototypeCommand.Builder builder() {
    return new ImmutableCreateRowGroupFromPrototypeCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateRowGroupFromPrototypeCommand ImmutableCreateRowGroupFromPrototypeCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateRowGroupFromPrototypeCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ITEM_PROTOTYPE_ID = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ItemStates>> triggers = ImmutableList.builder();
    private @Nullable ItemId itemPrototypeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRowGroupFromPrototypeCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateRowGroupFromPrototypeCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      this.itemPrototypeId(instance.getItemPrototypeId());
      return this;
    }

    /**
     * Adds one element to {@link CreateRowGroupFromPrototypeCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemStates> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateRowGroupFromPrototypeCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemStates>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateRowGroupFromPrototypeCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemStates>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link CreateRowGroupFromPrototypeCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRowGroupFromPrototypeCommand#getItemPrototypeId() itemPrototypeId} attribute.
     * @param itemPrototypeId The value for itemPrototypeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemPrototypeId(ItemId itemPrototypeId) {
      this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
      initBits &= ~INIT_BIT_ITEM_PROTOTYPE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateRowGroupFromPrototypeCommand ImmutableCreateRowGroupFromPrototypeCommand}.
     * @return An immutable instance of CreateRowGroupFromPrototypeCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateRowGroupFromPrototypeCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateRowGroupFromPrototypeCommand(null, triggers.build(), itemPrototypeId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEM_PROTOTYPE_ID) != 0) attributes.add("itemPrototypeId");
      return "Cannot build CreateRowGroupFromPrototypeCommand, some of required attributes are not set " + attributes;
    }
  }
}
