package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VariableItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariableItem.builder()}.
 */
@Generated(from = "VariableItem", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableVariableItem implements VariableItem {
  private final boolean isPrototype;
  private final ItemId id;
  private final String type;
  private final @Nullable String valueSetId;
  private final @Nullable Object defaultValue;
  private final Expression valueExpression;
  private final boolean isAsync;
  private final boolean isPublished;

  private ImmutableVariableItem(ImmutableVariableItem.Builder builder) {
    this.id = builder.id;
    this.type = builder.type;
    this.valueSetId = builder.valueSetId;
    this.defaultValue = builder.defaultValue;
    this.valueExpression = builder.valueExpression;
    if (builder.isPrototypeIsSet()) {
      initShim.isPrototype(builder.isPrototype);
    }
    if (builder.isAsyncIsSet()) {
      initShim.isAsync(builder.isAsync);
    }
    if (builder.isPublishedIsSet()) {
      initShim.isPublished(builder.isPublished);
    }
    this.isPrototype = initShim.isPrototype();
    this.isAsync = initShim.isAsync();
    this.isPublished = initShim.isPublished();
    this.initShim = null;
  }

  private ImmutableVariableItem(
      boolean isPrototype,
      ItemId id,
      String type,
      @Nullable String valueSetId,
      @Nullable Object defaultValue,
      Expression valueExpression,
      boolean isAsync,
      boolean isPublished) {
    this.isPrototype = isPrototype;
    this.id = id;
    this.type = type;
    this.valueSetId = valueSetId;
    this.defaultValue = defaultValue;
    this.valueExpression = valueExpression;
    this.isAsync = isAsync;
    this.isPublished = isPublished;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VariableItem", generator = "Immutables")
  private final class InitShim {
    private byte isPrototypeBuildStage = STAGE_UNINITIALIZED;
    private boolean isPrototype;

    boolean isPrototype() {
      if (isPrototypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isPrototypeBuildStage == STAGE_UNINITIALIZED) {
        isPrototypeBuildStage = STAGE_INITIALIZING;
        boolean computedValue = isPrototypeInitialize();
        this.isPrototype = computedValue;
        isPrototypeBuildStage = STAGE_INITIALIZED;
      }
      return this.isPrototype;
    }

    void isPrototype(boolean isPrototype) {
      this.isPrototype = isPrototype;
      isPrototypeBuildStage = STAGE_INITIALIZED;
    }

    private byte isAsyncBuildStage = STAGE_UNINITIALIZED;
    private boolean isAsync;

    boolean isAsync() {
      if (isAsyncBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isAsyncBuildStage == STAGE_UNINITIALIZED) {
        isAsyncBuildStage = STAGE_INITIALIZING;
        boolean computedValue = isAsyncInitialize();
        this.isAsync = computedValue;
        isAsyncBuildStage = STAGE_INITIALIZED;
      }
      return this.isAsync;
    }

    void isAsync(boolean isAsync) {
      this.isAsync = isAsync;
      isAsyncBuildStage = STAGE_INITIALIZED;
    }

    private byte isPublishedBuildStage = STAGE_UNINITIALIZED;
    private boolean isPublished;

    boolean isPublished() {
      if (isPublishedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isPublishedBuildStage == STAGE_UNINITIALIZED) {
        isPublishedBuildStage = STAGE_INITIALIZING;
        boolean computedValue = isPublishedInitialize();
        this.isPublished = computedValue;
        isPublishedBuildStage = STAGE_INITIALIZED;
      }
      return this.isPublished;
    }

    void isPublished(boolean isPublished) {
      this.isPublished = isPublished;
      isPublishedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (isPrototypeBuildStage == STAGE_INITIALIZING) attributes.add("isPrototype");
      if (isAsyncBuildStage == STAGE_INITIALIZING) attributes.add("isAsync");
      if (isPublishedBuildStage == STAGE_INITIALIZING) attributes.add("isPublished");
      return "Cannot build VariableItem, attribute initializers form cycle " + attributes;
    }
  }

  private boolean isPrototypeInitialize() {
    return VariableItem.super.isPrototype();
  }

  private boolean isAsyncInitialize() {
    return VariableItem.super.isAsync();
  }

  private boolean isPublishedInitialize() {
    return VariableItem.super.isPublished();
  }

  /**
   * @return The value of the {@code isPrototype} attribute
   */
  @Override
  public boolean isPrototype() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPrototype()
        : this.isPrototype;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public ItemId getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @Override
  public Optional<String> getValueSetId() {
    return Optional.ofNullable(valueSetId);
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @Override
  public Optional<Object> getDefaultValue() {
    return Optional.ofNullable(defaultValue);
  }

  /**
   * @return The value of the {@code valueExpression} attribute
   */
  @Override
  public Expression getValueExpression() {
    return valueExpression;
  }

  /**
   * @return The value of the {@code isAsync} attribute
   */
  @Override
  public boolean isAsync() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAsync()
        : this.isAsync;
  }

  /**
   * @return The value of the {@code isPublished} attribute
   */
  @Override
  public boolean isPublished() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPublished()
        : this.isPublished;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableItem#isPrototype() isPrototype} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPrototype
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableItem withIsPrototype(boolean value) {
    if (this.isPrototype == value) return this;
    return new ImmutableVariableItem(
        value,
        this.id,
        this.type,
        this.valueSetId,
        this.defaultValue,
        this.valueExpression,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableItem#getId() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableItem withId(ItemId value) {
    if (this.id == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "id");
    return new ImmutableVariableItem(
        this.isPrototype,
        newValue,
        this.type,
        this.valueSetId,
        this.defaultValue,
        this.valueExpression,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableItem#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableItem withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        newValue,
        this.valueSetId,
        this.defaultValue,
        this.valueExpression,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link VariableItem#getValueSetId() valueSetId} attribute.
   * @param value The value for valueSetId
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableVariableItem withValueSetId(String value) {
    String newValue = Objects.requireNonNull(value, "valueSetId");
    if (Objects.equals(this.valueSetId, newValue)) return this;
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        this.type,
        newValue,
        this.defaultValue,
        this.valueExpression,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link VariableItem#getValueSetId() valueSetId} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for valueSetId
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableVariableItem withValueSetId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.valueSetId, value)) return this;
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        this.type,
        value,
        this.defaultValue,
        this.valueExpression,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link VariableItem#getDefaultValue() defaultValue} attribute.
   * @param value The value for defaultValue
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableVariableItem withDefaultValue(Object value) {
    Object newValue = Objects.requireNonNull(value, "defaultValue");
    if (this.defaultValue == newValue) return this;
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueSetId,
        newValue,
        this.valueExpression,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link VariableItem#getDefaultValue() defaultValue} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for defaultValue
   * @return A modified copy or {@code this} if not changed
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableVariableItem withDefaultValue(Optional<? extends Object> optional) {
    @Nullable Object value = optional.orElse(null);
    if (this.defaultValue == value) return this;
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueSetId,
        value,
        this.valueExpression,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableItem#getValueExpression() valueExpression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueExpression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableItem withValueExpression(Expression value) {
    if (this.valueExpression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "valueExpression");
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueSetId,
        this.defaultValue,
        newValue,
        this.isAsync,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableItem#isAsync() isAsync} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isAsync
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableItem withIsAsync(boolean value) {
    if (this.isAsync == value) return this;
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueSetId,
        this.defaultValue,
        this.valueExpression,
        value,
        this.isPublished);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableItem#isPublished() isPublished} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPublished
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableItem withIsPublished(boolean value) {
    if (this.isPublished == value) return this;
    return new ImmutableVariableItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueSetId,
        this.defaultValue,
        this.valueExpression,
        this.isAsync,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariableItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariableItem
        && equalsByValue((ImmutableVariableItem) another);
  }

  private boolean equalsByValue(ImmutableVariableItem another) {
    return isPrototype == another.isPrototype
        && id.equals(another.id)
        && type.equals(another.type)
        && Objects.equals(valueSetId, another.valueSetId)
        && Objects.equals(defaultValue, another.defaultValue)
        && valueExpression.equals(another.valueExpression)
        && isAsync == another.isAsync
        && isPublished == another.isPublished;
  }

  /**
   * Computes a hash code from attributes: {@code isPrototype}, {@code id}, {@code type}, {@code valueSetId}, {@code defaultValue}, {@code valueExpression}, {@code isAsync}, {@code isPublished}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(isPrototype);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(valueSetId);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + valueExpression.hashCode();
    h += (h << 5) + Booleans.hashCode(isAsync);
    h += (h << 5) + Booleans.hashCode(isPublished);
    return h;
  }

  /**
   * Prints the immutable value {@code VariableItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("VariableItem")
        .omitNullValues()
        .add("isPrototype", isPrototype)
        .add("id", id)
        .add("type", type)
        .add("valueSetId", valueSetId)
        .add("defaultValue", defaultValue)
        .add("valueExpression", valueExpression)
        .add("isAsync", isAsync)
        .add("isPublished", isPublished)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link VariableItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VariableItem instance
   */
  public static ImmutableVariableItem copyOf(VariableItem instance) {
    if (instance instanceof ImmutableVariableItem) {
      return (ImmutableVariableItem) instance;
    }
    return ImmutableVariableItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariableItem ImmutableVariableItem}.
   * <pre>
   * ImmutableVariableItem.builder()
   *    .isPrototype(boolean) // optional {@link VariableItem#isPrototype() isPrototype}
   *    .id(io.dialob.session.engine.session.model.ItemId) // required {@link VariableItem#getId() id}
   *    .type(String) // required {@link VariableItem#getType() type}
   *    .valueSetId(Optional&lt;String&gt;) // optional {@link VariableItem#getValueSetId() valueSetId}
   *    .defaultValue(Optional&lt;Object&gt;) // optional {@link VariableItem#getDefaultValue() defaultValue}
   *    .valueExpression(io.dialob.session.engine.program.model.Expression) // required {@link VariableItem#getValueExpression() valueExpression}
   *    .isAsync(boolean) // optional {@link VariableItem#isAsync() isAsync}
   *    .isPublished(boolean) // optional {@link VariableItem#isPublished() isPublished}
   *    .build();
   * </pre>
   * @return A new ImmutableVariableItem builder
   */
  public static ImmutableVariableItem.Builder builder() {
    return new ImmutableVariableItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariableItem ImmutableVariableItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VariableItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_VALUE_EXPRESSION = 0x4L;
    private static final long OPT_BIT_IS_PROTOTYPE = 0x1L;
    private static final long OPT_BIT_IS_ASYNC = 0x2L;
    private static final long OPT_BIT_IS_PUBLISHED = 0x4L;
    private long initBits = 0x7L;
    private long optBits;

    private boolean isPrototype;
    private @Nullable ItemId id;
    private @Nullable String type;
    private @Nullable String valueSetId;
    private @Nullable Object defaultValue;
    private @Nullable Expression valueExpression;
    private boolean isAsync;
    private boolean isPublished;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Item} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Item instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.VariableItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(VariableItem instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.StructuralNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StructuralNode instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof Item) {
        Item instance = (Item) object;
        if ((bits & 0x10L) == 0) {
          this.id(instance.getId());
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          this.isPrototype(instance.isPrototype());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          Optional<Object> defaultValueOptional = instance.getDefaultValue();
          if (defaultValueOptional.isPresent()) {
            defaultValue(defaultValueOptional);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x8L) == 0) {
          Optional<String> valueSetIdOptional = instance.getValueSetId();
          if (valueSetIdOptional.isPresent()) {
            valueSetId(valueSetIdOptional);
          }
          bits |= 0x8L;
        }
      }
      if (object instanceof VariableItem) {
        VariableItem instance = (VariableItem) object;
        this.valueExpression(instance.getValueExpression());
        if ((bits & 0x4L) == 0) {
          this.isPrototype(instance.isPrototype());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          Optional<Object> defaultValueOptional = instance.getDefaultValue();
          if (defaultValueOptional.isPresent()) {
            defaultValue(defaultValueOptional);
          }
          bits |= 0x1L;
        }
        this.isPublished(instance.isPublished());
        if ((bits & 0x8L) == 0) {
          Optional<String> valueSetIdOptional = instance.getValueSetId();
          if (valueSetIdOptional.isPresent()) {
            valueSetId(valueSetIdOptional);
          }
          bits |= 0x8L;
        }
        this.isAsync(instance.isAsync());
        if ((bits & 0x10L) == 0) {
          this.id(instance.getId());
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
      }
      if (object instanceof StructuralNode) {
        StructuralNode instance = (StructuralNode) object;
        if ((bits & 0x4L) == 0) {
          this.isPrototype(instance.isPrototype());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link VariableItem#isPrototype() isPrototype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VariableItem#isPrototype() isPrototype}.</em>
     * @param isPrototype The value for isPrototype 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPrototype(boolean isPrototype) {
      this.isPrototype = isPrototype;
      optBits |= OPT_BIT_IS_PROTOTYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(ItemId id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableItem#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link VariableItem#getValueSetId() valueSetId} to valueSetId.
     * @param valueSetId The value for valueSetId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(String valueSetId) {
      this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
      return this;
    }

    /**
     * Initializes the optional value {@link VariableItem#getValueSetId() valueSetId} to valueSetId.
     * @param valueSetId The value for valueSetId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(Optional<String> valueSetId) {
      this.valueSetId = valueSetId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link VariableItem#getDefaultValue() defaultValue} to defaultValue.
     * @param defaultValue The value for defaultValue
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultValue(Object defaultValue) {
      this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
      return this;
    }

    /**
     * Initializes the optional value {@link VariableItem#getDefaultValue() defaultValue} to defaultValue.
     * @param defaultValue The value for defaultValue
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultValue(Optional<? extends Object> defaultValue) {
      this.defaultValue = defaultValue.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link VariableItem#getValueExpression() valueExpression} attribute.
     * @param valueExpression The value for valueExpression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueExpression(Expression valueExpression) {
      this.valueExpression = Objects.requireNonNull(valueExpression, "valueExpression");
      initBits &= ~INIT_BIT_VALUE_EXPRESSION;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableItem#isAsync() isAsync} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VariableItem#isAsync() isAsync}.</em>
     * @param isAsync The value for isAsync 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isAsync(boolean isAsync) {
      this.isAsync = isAsync;
      optBits |= OPT_BIT_IS_ASYNC;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableItem#isPublished() isPublished} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VariableItem#isPublished() isPublished}.</em>
     * @param isPublished The value for isPublished 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPublished(boolean isPublished) {
      this.isPublished = isPublished;
      optBits |= OPT_BIT_IS_PUBLISHED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariableItem ImmutableVariableItem}.
     * @return An immutable instance of VariableItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariableItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVariableItem(this);
    }

    private boolean isPrototypeIsSet() {
      return (optBits & OPT_BIT_IS_PROTOTYPE) != 0;
    }

    private boolean isAsyncIsSet() {
      return (optBits & OPT_BIT_IS_ASYNC) != 0;
    }

    private boolean isPublishedIsSet() {
      return (optBits & OPT_BIT_IS_PUBLISHED) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VALUE_EXPRESSION) != 0) attributes.add("valueExpression");
      return "Cannot build VariableItem, some of required attributes are not set " + attributes;
    }
  }
}
