package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Label}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLabel.builder()}.
 */
@Generated(from = "Label", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLabel implements Label {
  private final ImmutableMap<String, String> labels;

  private ImmutableLabel(ImmutableMap<String, String> labels) {
    this.labels = labels;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @Override
  public ImmutableMap<String, String> getLabels() {
    return labels;
  }

  /**
   * Copy the current immutable object by replacing the {@link Label#getLabels() labels} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the labels map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableLabel withLabels(Map<String, ? extends String> entries) {
    if (this.labels == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableLabel(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLabel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLabel
        && equalsByValue((ImmutableLabel) another);
  }

  private boolean equalsByValue(ImmutableLabel another) {
    return labels.equals(another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + labels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Label} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Label")
        .omitNullValues()
        .add("labels", labels)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Label} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Label instance
   */
  public static ImmutableLabel copyOf(Label instance) {
    if (instance instanceof ImmutableLabel) {
      return (ImmutableLabel) instance;
    }
    return ImmutableLabel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLabel ImmutableLabel}.
   * <pre>
   * ImmutableLabel.builder()
   *    .putLabels|putAllLabels(String =&gt; String) // {@link Label#getLabels() labels} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableLabel builder
   */
  public static ImmutableLabel.Builder builder() {
    return new ImmutableLabel.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLabel ImmutableLabel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Label", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, String> labels = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Label} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Label instance) {
      Objects.requireNonNull(instance, "instance");
      putAllLabels(instance.getLabels());
      return this;
    }

    /**
     * Put one entry to the {@link Label#getLabels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putLabels(String key, String value) {
      this.labels.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Label#getLabels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putLabels(Map.Entry<String, ? extends String> entry) {
      this.labels.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Label#getLabels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder labels(Map<String, ? extends String> entries) {
      this.labels = ImmutableMap.builder();
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Label#getLabels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllLabels(Map<String, ? extends String> entries) {
      this.labels.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableLabel ImmutableLabel}.
     * @return An immutable instance of Label
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLabel build() {
      return new ImmutableLabel(labels.build());
    }
  }
}
