package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Error}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableError.builder()}.
 */
@Generated(from = "Error", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableError implements Error {
  private final boolean isPrototype;
  private final @Nullable String code;
  private final ItemId itemId;
  private final Expression validationExpression;
  private final @javax.annotation.Nullable Expression disabledExpression;
  private final @Nullable Expression label;

  private ImmutableError(ImmutableError.Builder builder) {
    this.code = builder.code;
    this.itemId = builder.itemId;
    this.validationExpression = builder.validationExpression;
    this.disabledExpression = builder.disabledExpression;
    this.label = builder.label;
    this.isPrototype = builder.isPrototypeIsSet()
        ? builder.isPrototype
        : Error.super.isPrototype();
  }

  private ImmutableError(
      boolean isPrototype,
      @Nullable String code,
      ItemId itemId,
      Expression validationExpression,
      @javax.annotation.Nullable Expression disabledExpression,
      @Nullable Expression label) {
    this.isPrototype = isPrototype;
    this.code = code;
    this.itemId = itemId;
    this.validationExpression = validationExpression;
    this.disabledExpression = disabledExpression;
    this.label = label;
  }

  /**
   * @return The value of the {@code isPrototype} attribute
   */
  @Override
  public boolean isPrototype() {
    return isPrototype;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @Override
  public @Nullable String getCode() {
    return code;
  }

  /**
   * @return The value of the {@code itemId} attribute
   */
  @Override
  public ItemId getItemId() {
    return itemId;
  }

  /**
   * @return The value of the {@code validationExpression} attribute
   */
  @Override
  public Expression getValidationExpression() {
    return validationExpression;
  }

  /**
   * @return The value of the {@code disabledExpression} attribute
   */
  @Override
  public Optional<Expression> getDisabledExpression() {
    return Optional.ofNullable(disabledExpression);
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  public @Nullable Expression getLabel() {
    return label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#isPrototype() isPrototype} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPrototype
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableError withIsPrototype(boolean value) {
    if (this.isPrototype == value) return this;
    return new ImmutableError(value, this.code, this.itemId, this.validationExpression, this.disabledExpression, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getCode() code} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableError withCode(@Nullable String value) {
    if (Objects.equals(this.code, value)) return this;
    return new ImmutableError(
        this.isPrototype,
        value,
        this.itemId,
        this.validationExpression,
        this.disabledExpression,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getItemId() itemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableError withItemId(ItemId value) {
    if (this.itemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemId");
    return new ImmutableError(
        this.isPrototype,
        this.code,
        newValue,
        this.validationExpression,
        this.disabledExpression,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getValidationExpression() validationExpression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validationExpression
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableError withValidationExpression(Expression value) {
    if (this.validationExpression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "validationExpression");
    return new ImmutableError(this.isPrototype, this.code, this.itemId, newValue, this.disabledExpression, this.label);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link Error#getDisabledExpression() disabledExpression} attribute.
   * @param value The value for disabledExpression
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableError withDisabledExpression(Expression value) {
    Expression newValue = Objects.requireNonNull(value, "disabledExpression");
    if (this.disabledExpression == newValue) return this;
    return new ImmutableError(this.isPrototype, this.code, this.itemId, this.validationExpression, newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Error#getDisabledExpression() disabledExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for disabledExpression
   * @return A modified copy or {@code this} if not changed
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableError withDisabledExpression(Optional<? extends Expression> optional) {
    @javax.annotation.Nullable Expression value = optional.orElse(null);
    if (this.disabledExpression == value) return this;
    return new ImmutableError(this.isPrototype, this.code, this.itemId, this.validationExpression, value, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getLabel() label} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableError withLabel(@Nullable Expression value) {
    if (this.label == value) return this;
    return new ImmutableError(
        this.isPrototype,
        this.code,
        this.itemId,
        this.validationExpression,
        this.disabledExpression,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableError
        && equalsByValue((ImmutableError) another);
  }

  private boolean equalsByValue(ImmutableError another) {
    return isPrototype == another.isPrototype
        && Objects.equals(code, another.code)
        && itemId.equals(another.itemId)
        && validationExpression.equals(another.validationExpression)
        && Objects.equals(disabledExpression, another.disabledExpression)
        && Objects.equals(label, another.label);
  }

  /**
   * Computes a hash code from attributes: {@code isPrototype}, {@code code}, {@code itemId}, {@code validationExpression}, {@code disabledExpression}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(isPrototype);
    h += (h << 5) + Objects.hashCode(code);
    h += (h << 5) + itemId.hashCode();
    h += (h << 5) + validationExpression.hashCode();
    h += (h << 5) + Objects.hashCode(disabledExpression);
    h += (h << 5) + Objects.hashCode(label);
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Error")
        .omitNullValues()
        .add("isPrototype", isPrototype)
        .add("code", code)
        .add("itemId", itemId)
        .add("validationExpression", validationExpression)
        .add("disabledExpression", disabledExpression)
        .add("label", label)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Error} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Error instance
   */
  public static ImmutableError copyOf(Error instance) {
    if (instance instanceof ImmutableError) {
      return (ImmutableError) instance;
    }
    return ImmutableError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableError ImmutableError}.
   * <pre>
   * ImmutableError.builder()
   *    .isPrototype(boolean) // optional {@link Error#isPrototype() isPrototype}
   *    .code(String | null) // nullable {@link Error#getCode() code}
   *    .itemId(io.dialob.session.engine.session.model.ItemId) // required {@link Error#getItemId() itemId}
   *    .validationExpression(io.dialob.session.engine.program.model.Expression) // required {@link Error#getValidationExpression() validationExpression}
   *    .disabledExpression(Optional&lt;io.dialob.session.engine.program.model.Expression&gt;) // optional {@link Error#getDisabledExpression() disabledExpression}
   *    .label(io.dialob.session.engine.program.model.Expression | null) // nullable {@link Error#getLabel() label}
   *    .build();
   * </pre>
   * @return A new ImmutableError builder
   */
  public static ImmutableError.Builder builder() {
    return new ImmutableError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableError ImmutableError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Error", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ITEM_ID = 0x1L;
    private static final long INIT_BIT_VALIDATION_EXPRESSION = 0x2L;
    private static final long OPT_BIT_IS_PROTOTYPE = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private boolean isPrototype;
    private @javax.annotation.Nullable String code;
    private @javax.annotation.Nullable ItemId itemId;
    private @javax.annotation.Nullable Expression validationExpression;
    private @javax.annotation.Nullable Expression disabledExpression;
    private @javax.annotation.Nullable Expression label;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Error} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Error instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.StructuralNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StructuralNode instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof Error) {
        Error instance = (Error) object;
        this.itemId(instance.getItemId());
        this.validationExpression(instance.getValidationExpression());
        @Nullable String codeValue = instance.getCode();
        if (codeValue != null) {
          code(codeValue);
        }
        @Nullable Expression labelValue = instance.getLabel();
        if (labelValue != null) {
          label(labelValue);
        }
        if ((bits & 0x1L) == 0) {
          this.isPrototype(instance.isPrototype());
          bits |= 0x1L;
        }
        Optional<Expression> disabledExpressionOptional = instance.getDisabledExpression();
        if (disabledExpressionOptional.isPresent()) {
          disabledExpression(disabledExpressionOptional);
        }
      }
      if (object instanceof StructuralNode) {
        StructuralNode instance = (StructuralNode) object;
        if ((bits & 0x1L) == 0) {
          this.isPrototype(instance.isPrototype());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Error#isPrototype() isPrototype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Error#isPrototype() isPrototype}.</em>
     * @param isPrototype The value for isPrototype 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPrototype(boolean isPrototype) {
      this.isPrototype = isPrototype;
      optBits |= OPT_BIT_IS_PROTOTYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder code(@Nullable String code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getItemId() itemId} attribute.
     * @param itemId The value for itemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemId(ItemId itemId) {
      this.itemId = Objects.requireNonNull(itemId, "itemId");
      initBits &= ~INIT_BIT_ITEM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getValidationExpression() validationExpression} attribute.
     * @param validationExpression The value for validationExpression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validationExpression(Expression validationExpression) {
      this.validationExpression = Objects.requireNonNull(validationExpression, "validationExpression");
      initBits &= ~INIT_BIT_VALIDATION_EXPRESSION;
      return this;
    }

    /**
     * Initializes the optional value {@link Error#getDisabledExpression() disabledExpression} to disabledExpression.
     * @param disabledExpression The value for disabledExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder disabledExpression(Expression disabledExpression) {
      this.disabledExpression = Objects.requireNonNull(disabledExpression, "disabledExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Error#getDisabledExpression() disabledExpression} to disabledExpression.
     * @param disabledExpression The value for disabledExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder disabledExpression(Optional<? extends Expression> disabledExpression) {
      this.disabledExpression = disabledExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getLabel() label} attribute.
     * @param label The value for label (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder label(@Nullable Expression label) {
      this.label = label;
      return this;
    }

    /**
     * Builds a new {@link ImmutableError ImmutableError}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableError(this);
    }

    private boolean isPrototypeIsSet() {
      return (optBits & OPT_BIT_IS_PROTOTYPE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEM_ID) != 0) attributes.add("itemId");
      if ((initBits & INIT_BIT_VALIDATION_EXPRESSION) != 0) attributes.add("validationExpression");
      return "Cannot build Error, some of required attributes are not set " + attributes;
    }
  }
}
