package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.rule.parser.api.ValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConstantValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConstantValue.builder()}.
 */
@Generated(from = "ConstantValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConstantValue<T>
    implements ConstantValue<T> {
  private final T value;
  private final @Nullable ValueType valueType;

  private ImmutableConstantValue(T value, @Nullable ValueType valueType) {
    this.value = value;
    this.valueType = valueType;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T getValue() {
    return value;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public @Nullable ValueType getValueType() {
    return valueType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConstantValue#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableConstantValue<T> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableConstantValue<>(newValue, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConstantValue#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableConstantValue<T> withValueType(@Nullable ValueType value) {
    if (this.valueType == value) return this;
    return new ImmutableConstantValue<>(this.value, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConstantValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConstantValue<?>
        && equalsByValue((ImmutableConstantValue<?>) another);
  }

  private boolean equalsByValue(ImmutableConstantValue<?> another) {
    return value.equals(another.value)
        && Objects.equals(valueType, another.valueType);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code valueType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + Objects.hashCode(valueType);
    return h;
  }

  /**
   * Prints the immutable value {@code ConstantValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConstantValue")
        .omitNullValues()
        .add("value", value)
        .add("valueType", valueType)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ConstantValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ConstantValue instance
   */
  public static <T> ImmutableConstantValue<T> copyOf(ConstantValue<T> instance) {
    if (instance instanceof ImmutableConstantValue<?>) {
      return (ImmutableConstantValue<T>) instance;
    }
    return ImmutableConstantValue.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConstantValue ImmutableConstantValue}.
   * <pre>
   * ImmutableConstantValue.&lt;T&gt;builder()
   *    .value(T) // required {@link ConstantValue#getValue() value}
   *    .valueType(io.dialob.rule.parser.api.ValueType | null) // nullable {@link ConstantValue#getValueType() valueType}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableConstantValue builder
   */
  public static <T> ImmutableConstantValue.Builder<T> builder() {
    return new ImmutableConstantValue.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableConstantValue ImmutableConstantValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConstantValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable T value;
    private @javax.annotation.Nullable ValueType valueType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Value} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Value<T> instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.ConstantValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ConstantValue<T> instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof Value<?>) {
        Value<T> instance = (Value<T>) object;
        if ((bits & 0x1L) == 0) {
          @Nullable ValueType valueTypeValue = instance.getValueType();
          if (valueTypeValue != null) {
            valueType(valueTypeValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof ConstantValue<?>) {
        ConstantValue<T> instance = (ConstantValue<T>) object;
        this.value(instance.getValue());
        if ((bits & 0x1L) == 0) {
          @Nullable ValueType valueTypeValue = instance.getValueType();
          if (valueTypeValue != null) {
            valueType(valueTypeValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ConstantValue#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link ConstantValue#getValueType() valueType} attribute.
     * @param valueType The value for valueType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> valueType(@Nullable ValueType valueType) {
      this.valueType = valueType;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConstantValue ImmutableConstantValue}.
     * @return An immutable instance of ConstantValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConstantValue<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConstantValue<>(value, valueType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build ConstantValue, some of required attributes are not set " + attributes;
    }
  }
}
