package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.rule.parser.api.ValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConditionalValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConditionalValue.builder()}.
 */
@Generated(from = "ConditionalValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConditionalValue<T>
    implements ConditionalValue<T> {
  private final Expression when;
  private final @Nullable T value;
  private final @Nullable T fallbackValue;
  private final ValueType valueType;

  private ImmutableConditionalValue(
      Expression when,
      @Nullable T value,
      @Nullable T fallbackValue,
      ValueType valueType) {
    this.when = when;
    this.value = value;
    this.fallbackValue = fallbackValue;
    this.valueType = valueType;
  }

  /**
   * @return The value of the {@code when} attribute
   */
  @Override
  public Expression getWhen() {
    return when;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable T getValue() {
    return value;
  }

  /**
   * @return The value of the {@code fallbackValue} attribute
   */
  @Override
  public @Nullable T getFallbackValue() {
    return fallbackValue;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public ValueType getValueType() {
    return valueType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConditionalValue#getWhen() when} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for when
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableConditionalValue<T> withWhen(Expression value) {
    if (this.when == value) return this;
    Expression newValue = Objects.requireNonNull(value, "when");
    return new ImmutableConditionalValue<>(newValue, this.value, this.fallbackValue, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConditionalValue#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableConditionalValue<T> withValue(@Nullable T value) {
    if (this.value == value) return this;
    return new ImmutableConditionalValue<>(this.when, value, this.fallbackValue, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConditionalValue#getFallbackValue() fallbackValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fallbackValue (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableConditionalValue<T> withFallbackValue(@Nullable T value) {
    if (this.fallbackValue == value) return this;
    return new ImmutableConditionalValue<>(this.when, this.value, value, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConditionalValue#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableConditionalValue<T> withValueType(ValueType value) {
    if (this.valueType == value) return this;
    ValueType newValue = Objects.requireNonNull(value, "valueType");
    return new ImmutableConditionalValue<>(this.when, this.value, this.fallbackValue, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConditionalValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConditionalValue<?>
        && equalsByValue((ImmutableConditionalValue<?>) another);
  }

  private boolean equalsByValue(ImmutableConditionalValue<?> another) {
    return when.equals(another.when)
        && Objects.equals(value, another.value)
        && Objects.equals(fallbackValue, another.fallbackValue)
        && valueType.equals(another.valueType);
  }

  /**
   * Computes a hash code from attributes: {@code when}, {@code value}, {@code fallbackValue}, {@code valueType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + when.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(fallbackValue);
    h += (h << 5) + valueType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConditionalValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConditionalValue")
        .omitNullValues()
        .add("when", when)
        .add("value", value)
        .add("fallbackValue", fallbackValue)
        .add("valueType", valueType)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ConditionalValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ConditionalValue instance
   */
  public static <T> ImmutableConditionalValue<T> copyOf(ConditionalValue<T> instance) {
    if (instance instanceof ImmutableConditionalValue<?>) {
      return (ImmutableConditionalValue<T>) instance;
    }
    return ImmutableConditionalValue.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConditionalValue ImmutableConditionalValue}.
   * <pre>
   * ImmutableConditionalValue.&lt;T&gt;builder()
   *    .when(io.dialob.session.engine.program.model.Expression) // required {@link ConditionalValue#getWhen() when}
   *    .value(T | null) // nullable {@link ConditionalValue#getValue() value}
   *    .fallbackValue(T | null) // nullable {@link ConditionalValue#getFallbackValue() fallbackValue}
   *    .valueType(io.dialob.rule.parser.api.ValueType) // required {@link ConditionalValue#getValueType() valueType}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableConditionalValue builder
   */
  public static <T> ImmutableConditionalValue.Builder<T> builder() {
    return new ImmutableConditionalValue.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableConditionalValue ImmutableConditionalValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConditionalValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_WHEN = 0x1L;
    private static final long INIT_BIT_VALUE_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable Expression when;
    private @javax.annotation.Nullable T value;
    private @javax.annotation.Nullable T fallbackValue;
    private @javax.annotation.Nullable ValueType valueType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Value} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Value<T> instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.ConditionalValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ConditionalValue<T> instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof Value<?>) {
        Value<T> instance = (Value<T>) object;
        if ((bits & 0x1L) == 0) {
          this.valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
      if (object instanceof ConditionalValue<?>) {
        ConditionalValue<T> instance = (ConditionalValue<T>) object;
        this.when(instance.getWhen());
        @Nullable T valueValue = instance.getValue();
        if (valueValue != null) {
          value(valueValue);
        }
        @Nullable T fallbackValueValue = instance.getFallbackValue();
        if (fallbackValueValue != null) {
          fallbackValue(fallbackValueValue);
        }
        if ((bits & 0x1L) == 0) {
          this.valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ConditionalValue#getWhen() when} attribute.
     * @param when The value for when 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> when(Expression when) {
      this.when = Objects.requireNonNull(when, "when");
      initBits &= ~INIT_BIT_WHEN;
      return this;
    }

    /**
     * Initializes the value for the {@link ConditionalValue#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(@Nullable T value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the value for the {@link ConditionalValue#getFallbackValue() fallbackValue} attribute.
     * @param fallbackValue The value for fallbackValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> fallbackValue(@Nullable T fallbackValue) {
      this.fallbackValue = fallbackValue;
      return this;
    }

    /**
     * Initializes the value for the {@link ConditionalValue#getValueType() valueType} attribute.
     * @param valueType The value for valueType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> valueType(ValueType valueType) {
      this.valueType = Objects.requireNonNull(valueType, "valueType");
      initBits &= ~INIT_BIT_VALUE_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConditionalValue ImmutableConditionalValue}.
     * @return An immutable instance of ConditionalValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConditionalValue<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConditionalValue<>(when, value, fallbackValue, valueType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WHEN) != 0) attributes.add("when");
      if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
      return "Cannot build ConditionalValue, some of required attributes are not set " + attributes;
    }
  }
}
