package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VariableReference}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariableReference.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableVariableReference.of()}.
 */
@Generated(from = "VariableReference", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableVariableReference<T>
    implements VariableReference<T> {
  private final ValueType valueType;
  private final ItemId itemId;

  private ImmutableVariableReference(ItemId itemId, ValueType valueType) {
    this.itemId = Objects.requireNonNull(itemId, "itemId");
    this.valueType = Objects.requireNonNull(valueType, "valueType");
  }

  private ImmutableVariableReference(
      ImmutableVariableReference<T> original,
      ValueType valueType,
      ItemId itemId) {
    this.valueType = valueType;
    this.itemId = itemId;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public ValueType getValueType() {
    return valueType;
  }

  /**
   * @return The value of the {@code itemId} attribute
   */
  @Override
  public ItemId getItemId() {
    return itemId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableReference#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableReference<T> withValueType(ValueType value) {
    if (this.valueType == value) return this;
    ValueType newValue = Objects.requireNonNull(value, "valueType");
    return new ImmutableVariableReference<>(this, newValue, this.itemId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableReference#getItemId() itemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVariableReference<T> withItemId(ItemId value) {
    if (this.itemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemId");
    return new ImmutableVariableReference<>(this, this.valueType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariableReference} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariableReference<?>
        && equalsByValue((ImmutableVariableReference<?>) another);
  }

  private boolean equalsByValue(ImmutableVariableReference<?> another) {
    return valueType.equals(another.valueType)
        && itemId.equals(another.itemId);
  }

  /**
   * Computes a hash code from attributes: {@code valueType}, {@code itemId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueType.hashCode();
    h += (h << 5) + itemId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VariableReference} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("VariableReference")
        .omitNullValues()
        .add("valueType", valueType)
        .add("itemId", itemId)
        .toString();
  }

  /**
   * Construct a new immutable {@code VariableReference} instance.
 * @param <T> generic parameter T
   * @param itemId The value for the {@code itemId} attribute
   * @param valueType The value for the {@code valueType} attribute
   * @return An immutable VariableReference instance
   */
  public static <T> ImmutableVariableReference<T> of(ItemId itemId, ValueType valueType) {
    return new ImmutableVariableReference<>(itemId, valueType);
  }

  /**
   * Creates an immutable copy of a {@link VariableReference} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable VariableReference instance
   */
  public static <T> ImmutableVariableReference<T> copyOf(VariableReference<T> instance) {
    if (instance instanceof ImmutableVariableReference<?>) {
      return (ImmutableVariableReference<T>) instance;
    }
    return ImmutableVariableReference.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariableReference ImmutableVariableReference}.
   * <pre>
   * ImmutableVariableReference.&lt;T&gt;builder()
   *    .valueType(io.dialob.rule.parser.api.ValueType) // required {@link VariableReference#getValueType() valueType}
   *    .itemId(io.dialob.session.engine.session.model.ItemId) // required {@link VariableReference#getItemId() itemId}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableVariableReference builder
   */
  public static <T> ImmutableVariableReference.Builder<T> builder() {
    return new ImmutableVariableReference.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableVariableReference ImmutableVariableReference}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VariableReference", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_VALUE_TYPE = 0x1L;
    private static final long INIT_BIT_ITEM_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ValueType valueType;
    private @Nullable ItemId itemId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.expr.arith.VariableReference} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(VariableReference<T> instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Expression} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Expression instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void mergeInternal(Object object) {
      @Var long bits = 0;
      if (object instanceof VariableReference<?>) {
        VariableReference<T> instance = (VariableReference<T>) object;
        this.itemId(instance.getItemId());
        if ((bits & 0x1L) == 0) {
          this.valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
      if (object instanceof Expression) {
        Expression instance = (Expression) object;
        if ((bits & 0x1L) == 0) {
          this.valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link VariableReference#getValueType() valueType} attribute.
     * @param valueType The value for valueType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> valueType(ValueType valueType) {
      this.valueType = Objects.requireNonNull(valueType, "valueType");
      initBits &= ~INIT_BIT_VALUE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableReference#getItemId() itemId} attribute.
     * @param itemId The value for itemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> itemId(ItemId itemId) {
      this.itemId = Objects.requireNonNull(itemId, "itemId");
      initBits &= ~INIT_BIT_ITEM_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariableReference ImmutableVariableReference}.
     * @return An immutable instance of VariableReference
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariableReference<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVariableReference<>(null, valueType, itemId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
      if ((initBits & INIT_BIT_ITEM_ID) != 0) attributes.add("itemId");
      return "Cannot build VariableReference, some of required attributes are not set " + attributes;
    }
  }
}
